/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Ball_Trait.hh @see Ball_Trait.hh Implementation in
    Ball.cc */

#ifndef XBOBBLE_BALL_TRAIT_HH
#define XBOBBLE_BALL_TRAIT_HH

#include <ayq/stdint.h>
#include <stdexcept>

namespace XBobble
{

class Grid;

/// Define a Ball's characteristics (colour, etc) and draw it
class Ball_Trait
{
public:
	/// As above, but arguments sorted in order given in an array
	Ball_Trait(const uint32_t arglod, const float radius,
		   const float params[13]);

	/// Copy constructor copies across display list data
	Ball_Trait(const Ball_Trait&) throw();

	/// Assignment operator does the same as Ball_Trait()
	Ball_Trait&
	operator=(const Ball_Trait&) throw();

	/// For when we get deleted
	virtual
	~Ball_Trait();

	/// OpenGL commands to draw this ball
	void
	draw_commands() const;

	/// @see users
	uint32_t
	get_users() const
	{
		return users;
	}

	/// Set users to this amount
	void
	set_users(const uint32_t arg)
	{
		users = arg;
	}

	/// Deccrement users by one.  Throw underflow_error if not
	/// enough users.  Returns new amount of users.
	uint32_t
	dec_users()
	{
		if(users == 0)
			throw std::underflow_error("Ball_Trait::dec_users()"
						   " - not enough users!");
		return --users;
	}

	/// Inc users.  NOTE; DOESN'T CHECK FOR OVERFLOW.  Returns new
	/// value.
	uint32_t
	inc_users()
	{
		return ++users;
	}

protected:
	/// How many balls are using this ball trait?
	uint32_t users;

	/// Holds display list for ball
	uint32_t one_ball_dl;

	/// Reference counting scemantics - only deletes display list
	/// if no shared owners left.
	unsigned long* shared_owners;

}; // class Ball_Trait


} // namespace XBobble


#endif // #define XBOBBLE_BALL_TRAIT_HH
