/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Finished_Level_State.cc @see Finished_Level_State.hh */

#include "Finished_Level_State.hh"
#include "Game.hh"
#include "Grid.hh"
#include "Game_Manager.hh"
#include "util.hh"
#include <iostream>
#include <sstream>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <errno.h>
#include <string.h>
#include <vector>
#include <string>
#include <iterator>

namespace XBobble
{

/// Impl class for Finished_Level_State
class Finished_Level_State::Impl
{
	/// Default inits
	Impl()
	 : current_level(1)
	{
	}

	friend class Finished_Level_State;

	/// The level currently being played.  Begins at 1.
	uint32_t current_level;

}; // class Finished_Level_State::Impl

namespace Vars { extern const uint32_t highest_level; }

Finished_Level_State::Finished_Level_State(Game::Impl& arg)
 : State(arg), impl(new Impl())
{
    try
    {
	// Find the highest level available
	DIR* tmpdir;
	std::vector<std::string> dirs;
	std::string lvldir = game.game_manager.get_option("data_root")
		+ "/levels";
// 	std::cerr << "lvldir=" << lvldir << std::endl; std::cerr.flush();
	errno = 0;
	tmpdir = opendir(lvldir.c_str());
	if(!tmpdir)
		throw Init_Error(std::string("Finished_Level_State() - ")
				 + " Couldn't open data_root! Errno: "
				 + strerror(errno));
	errno = 0;
	struct dirent* tmpdirent = 0;
	while((tmpdirent = readdir(tmpdir))) {
		dirs.push_back(tmpdirent->d_name);
	}
	if(errno == EBADF)
		throw Init_Error(std::string("Finished_Level_State() - ")
				 + " data_root is baaaaaad! Errno: "
				 + strerror(errno));
	closedir(tmpdir);

// 	copy(dirs.begin(), dirs.end(),
// 	     std::ostream_iterator<std::string>(std::cout, ", "));
// 	std::cout.flush();

	uint32_t highest = 0;
	std::string highest_str;
	for(std::vector<std::string>::iterator it = dirs.begin(),
		    itend = dirs.end(); it != itend; ++it) {
		struct stat tmpstat;
		if(stat((lvldir+"/"+*it).c_str(), &tmpstat) != 0) {
// 			std::cerr << *it << " messup during stat" << std::endl;
// 			std::cerr.flush();
			continue;
		}
		if(!S_ISREG(tmpstat.st_mode)) {
// 			std::cerr << *it << " not a file" << std::endl;
// 			std::cerr.flush();
			continue;
		}

		// if(it->size() <= const std::string("level.grid").size())
		if(it->size() <= 10) {
// 			std::cerr << *it << "not enuf lettus" << std::endl;
// 			std::cerr.flush();
			continue;
		}
		if(it->substr(0, 5) != "level") {
// 			std::cerr << *it << " != level" << std::endl;
// 			std::cerr.flush();
			continue;
		}
		it->erase(0, 5);
		if(it->substr(it->size()-5, 5) != ".grid") {
// 			std::cerr << *it << " != .grid" << std::endl;
// 			std::cerr.flush();
			continue;
		}
		it->erase(it->size()-5, 5);
		if(it->find_first_not_of("1234567890") != std::string::npos) {
// 			std::cerr << *it << " not num" << std::endl;
// 			std::cerr.flush();
			continue;
		}

		// We are sure now that we have a number!
// 		std::cerr << static_cast<uint32_t>(atoi(it->c_str()))
// 			  << std::endl;
// 		std::cerr.flush();
		if(static_cast<uint32_t>(atoi(it->c_str())) > highest) {
			highest = static_cast<uint32_t>(atoi(it->c_str()));
			highest_str.swap(*it);
		}
	}

	if(highest < 1)
		throw Init_Error(std::string("Finished_Level_State() - ")
				 + " no levels found!");
	game.game_manager.set_option("highest_level", highest_str.c_str());
// 	std::cout << "Highest level is " << highest_str << std::endl;
// 	std::cout.flush();
// 	throw int();
    }
    catch(...)
    {
	    delete impl;
	    throw;
    }
}

Finished_Level_State::~Finished_Level_State()
{
	delete impl;
}

void
Finished_Level_State::reset()
{
	impl->current_level = 1;
	get_grid().load_from_file("level1.grid");
}

void
Finished_Level_State::entry()
{
	++(impl->current_level);
}

void
Finished_Level_State::exit()
{
	uint32_t highest_level
		= atoi(game.game_manager.get_option("highest_level").c_str());
	if(impl->current_level <= highest_level) {
		std::ostringstream lvlnum;
		lvlnum << impl->current_level;
// 		std::cout << "Loading level " << lvlnum.str() << '\n';
		get_grid().load_from_file(std::string("level") + lvlnum.str()
					  + ".grid");
	}
}

void
Finished_Level_State::tock(uint32_t)
{
	uint32_t highest_level
		= atoi(game.game_manager.get_option("highest_level").c_str());
	if(impl->current_level > highest_level) {
		game.set_state(Game::GAME_OVER);
		return;
	}
	game.set_state(Game::GAMEPLAY);
}

void
Finished_Level_State::tick(uint32_t)
{
}

void
Finished_Level_State::sync_tick(uint32_t)
{
}



} // namespace XBobble



