/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Gameplay_State.hh The compound state used by Game to control
    gameplay */

#ifndef XBOBBLE_GAMEPLAY_STATE_HH
#define XBOBBLE_GAMEPLAY_STATE_HH

#include <ayq/stdint.h>
#include "State.hh"

namespace XBobble
{

class Game;

/// State controlling gameplay
class Gameplay_State : public State
{
public:
	/// Substate names
	enum {
		NONE = 0,
		WAITING = 1,
		LAUNCHING = 2,
	};

private:
	/// Which substate is current
	int substate;

public:
	/// NOTE that no entry/exit things are called here.  Call
	/// 'entry()' to set the default substate.
	Gameplay_State(Game::Impl& arg);

	/// Changes the substate to the given one.  If changing to the
	/// current state, equates to a no-op.  Calls
	/// subexit()/subentry() as required.
	virtual void
	set_substate(int arg);

	/// Returns the current state
	int
	get_substate() const
	{
		return substate;
	}

private:
	/// Entry actions for substates
	void
	subentry();

	/// Exit actions for substates
	void
	subexit();

public:
	/// Entering this state - sets substate to 'WAITING'
	virtual void
	entry();

	/// Leaving this state - sets substate to 'NONE'
	virtual void
	exit();

	/// Do tock processing
	virtual void
	tock(uint32_t);

	/// Tick-based function for this state
	virtual void
	tick(uint32_t);

	/// Sync-tick function for this state
	virtual void
	sync_tick(uint32_t);

}; // class Gameplay_State



} // namespace XBobble

#endif// #define XBOBBLE_GAMEPLAY_STATE_HH


