/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Out_Of_Game_State.hh */

#ifndef XBOBBLE_OUT_OF_GAME_STATE_HH
#define XBOBBLE_OUT_OF_GAME_STATE_HH

#include <ayq/stdint.h>
#include <memory>
#include "State.hh"
#include "Video_Data.hh"

namespace XBobble
{

class Game;
class std::invalid_argument;

/// The various things that go on outside of main gameplay (highscore,
/// intro, etc.)
class Out_Of_Game_State : public State, public Video_Data
{
public:
	/// That's right!
	class Pimpl;

	/// Init with game
	Out_Of_Game_State(Game::Impl& arg);

	/// Get rid of pimpl
	virtual
	~Out_Of_Game_State();

	/// Call on entering this out_of_game_state
	void
	entry();

	/// Call on leaving this out_of_game_state
	void
	exit();

	/// Do tock processing
	void
	tock(uint32_t);

	/// Tick-based function for this out_of_game_state
	void
	tick(uint32_t);

	/// Sync-tick function for this out_of_game_state
	void
	sync_tick(uint32_t);

private:
	/// Do the various drawing routines
	void
	draw_handler() const;

	/// Yep
	Pimpl* impl;

}; // class Out_Of_Game_State



} // namespace XBobble

#endif// #define XBOBBLE_OUT_OF_GAME_STATE_HH


