/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Sound_Output_Manager.hh Classes for sound output. */

#ifndef XBOBBLE_SOUND_OUTPUT_MANAGER_HH
#define XBOBBLE_SOUND_OUTPUT_MANAGER_HH

#include <string>
#include <stdexcept>
#include <SDL_mixer.h>
#include "util.hh"

namespace XBobble {

class System;
class Sound_Data;

/// Abstract sound playing class
class Sound_Output_Manager : public Singleton_Class
{
public:
	/// Default constructor
	Sound_Output_Manager(System& arg_sys);

	/// Closes SDL_mixer
	virtual
	~Sound_Output_Manager()
	{
		Mix_CloseAudio();
	}

	/// Load the sound 'filename' (absolute if beginning with '/'
	/// or relative to data root pathname if not) into data.
	/// Throws invalid_argument on error.
	void
	load_sound(const std::string& filename, Sound_Data& data);

protected:
	/// The system
	System& system;

	/// Number of channels reserved so far
	std::size_t used_channels;

}; // class Sound_Output_Manager

}; //namespace XBobble

#endif// #define SOUND_OUTPUT_MANAGER_HH


