/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Timeout_Meter.hh */

#ifndef XBOBBLE_TIMEOUT_METER_HH
#define XBOBBLE_TIMEOUT_METER_HH

#include <ayq/stdint.h>
#include "Game_Element.hh"
#include "Video_Data.hh"

namespace XBobble
{

class Game;

/// Displays the timeout when the player takes too long to do launch
/// the ball
class Timeout_Meter : public Game_Element, public Video_Data
{
public:
	/// Init with arg
	Timeout_Meter(Game::Impl& arg);

	/// Draw the timeout meter
	void
	draw_handler() const;

}; // class Timeout_Meter



} // namespace XBobble

#endif // #define XBOBBLE_TIMEOUT_METER_HH

