#ifndef CONF_H
#define CONF_H

#include <stdint.h>
#include "utf8.h"
#include "hash.h"

typedef struct _xdc_conf_t xdc_conf_t;
struct _xdc_conf_t {
  void *symtab;
  void *wsymtab;
  int warn;
  int skip_abbrev;

  int cmd_lang_from;
  int cmd_lang_from_all;
  int env_lang_from;
  int env_lang_from_all;
  int cfg_lang_from;
  int cfg_lang_from_all;
  int cmd_lang_to;
  int cmd_lang_to_all;
  int env_lang_to;
  int env_lang_to_all;
  int cfg_lang_to;
  int cfg_lang_to_all;
  int cmd_dict_name;
  int env_dict_name;
  int cfg_dict_name;
  int cmd_verbose;
  int env_verbose;
  int cfg_verbose;
  int verbose;
  int cmd_no_verbose;
  int cmd_list;
  int list_dicts;
  int describe;
  int use_colors;
};

void xdc_conf_init(xdc_conf_t *xdc_conf, int argc, char **argv);
void xdc_conf_set_defaults(xdc_conf_t *xdc_conf);
int xdc_conf_file_read(xdc_conf_t *xdc_conf);
void xdc_conf_read_env(xdc_conf_t *xdc_conf);
int xdc_conf_read_args(xdc_conf_t *xdc_conf, int argc, char **argv);
nameval_t* xdc_conf_add_arg(xdc_conf_t *xdc_conf, char *arg, char *val);
xdc_conf_t* create_xdc_conf(int argc, char *argv[]);
xdc_conf_t* get_xdc_conf(void);
void free_xdc_conf(xdc_conf_t *xdc_conf);
int save_arg_path(xdc_conf_t *xdc_conf, char *arg, char *name);
int save_arg_lang(xdc_conf_t *xdc_conf, char *arg, char *src, char *fromto);
int save_arg_dict_name(xdc_conf_t *xdc_conf, char *arg, char *hash_name);
int parse_true_false(char *str);

#define RE_NMATCH 10
#define PMATCH_SET_NUM 10

#endif
