#!/bin/bash
PACKAGE=xhotkeys

##################
error()
{
	echo $1
	exit 1
}

## MAIN
###############

# Some checks
FILES="CVS/Root debian/changelog"
for FILE in $FILES; do 
	if [ ! -e $FILE ]; then error "file not found: $FILE"; fi
done

CVSROOT=$(cat CVS/Root)
DEBIAN_VERSION=$(cat debian/changelog | head -n1 | awk '{print $2}' | sed "s/^.//" | sed "s/.$//")
VERSION=$(echo $DEBIAN_VERSION | cut -d"-" -f1)

echo "debian version: $DEBIAN_VERSION"

DIR=$(pwd)
cd /tmp && rm -rf $PACKAGE* && cvs -d "$CVSROOT" export -D now $PACKAGE || error "cannot read from CVS"
mv /tmp/$PACKAGE /tmp/$PACKAGE-$VERSION || error "cannot move temporal directory"
cd /tmp/$PACKAGE-$VERSION && fakeroot dpkg-buildpackage || error "cannot build debian package"
cd $DIR
DEBS=$(cat /tmp/$PACKAGE-$VERSION/debian/files | awk '{print $1}')
if [ "$DEBS" = "" ]; then error "file not found in temporal directory: debian/files"; fi
for DEB in $DEBS; do
	cp /tmp/$DEB  .. || error "cannot copy file: $DEB"
	echo "output file: ../$(basename $DEB)"
done

fakeroot debian/rules clean

exit 0