#!/usr/bin/python

# Arnau Sanchez (arnau@ehas.org)

# Solves simple math problem: 
#	Given a bunch of numbers, and using the 4 basic 
#	rules (+, -, /, *)  with the them, find (or be close to) 
#	another given number. Spanish reades will know it
# 	for the "Cifras y Letras" quiz show.

import os, sys, time

nearest = 0

########################
########################

class number(int):
	def __new__(cls, valor, string = None):
		self = int.__new__(cls, valor)
		if string != None: self.string = string
		else: self.string = str(valor)
		return self

	def __add__(self, n):
		return self.__class__(int.__add__(self, n), "(%s+%s)" %(self.string, n.string))

	def __sub__(self, n):
		return self.__class__(int.__sub__(self, n), "(%s-%s)" %(self.string, n.string))

	def __div__(self, n):
		return self.__class__(int.__div__(self, n), "(%s/%s)" %(self.string, n.string))

	def __mul__(self, n):
		return self.__class__(int.__mul__(self, n), "(%s*%s)" %(self.string, n.string))

	def __repr__(self):
		return self.string

########################
def pair_process(a, b):
	if a < b: a,b = b,a
	values = [a, b, a+b, a*b]
	if int(a)!=int(b): values.append(a-b)
	if not int(a)%int(b): values.append(a/b)	
	return values

########################
def process(final, numbers, transform = False):
	global nearest
	if transform: numbers = [number(x) for x in numbers]
		
	if len(numbers) == 2:
		res = pair_process(*numbers)
		for r in res:
			if final == r: return repr(r)
			elif abs(final - int(r)) < abs(int(final) - nearest):
				nearest = int(r)
				print "%d = %s" %(nearest, repr(r))
		return res

	for index1, number1 in enumerate(numbers[:-1]):
		for index2 in range(index1+1, len(numbers)-1):
			number2 = numbers[index2]
			others = numbers[:index1] + numbers[index1+1:index2] + numbers[index2+1:]
			for num in pair_process(number1, number2):
				proc =  process(final, [num] + others)
				if type(proc) == str: return proc

###########################
### MAIN
############

def main():
	global nearest
	args = sys.argv[1:]
	if len(args) < 2:
		print "usage: numbers.py n1 [n2] ... [nN] final"
		sys.exit(1)
	final = int(args.pop())
	numbers = [int(x) for x in args]
	print "initial numbers: " + ", ".join(args)
	print "final number: %d" %final
	t0 = time.time()
	res = process(final, numbers, transform = True)
	if res: print "Found: %d = %s (%0.2f secs)" %(final, res, time.time() - t0)
	else: print "Not found"
	
if __name__ == "__main__":
	main()