/* X Language - Calculator 0.1
 * -----------------------
 *
 * This program is a X Language example
 */

pointer     frame;
pointer     fixed;
pointer     entry;
pointer	    b[10];
pointer     bp;

pointer  bclean;
pointer  badd;
pointer  bmin;
pointer  bmul;
pointer  bdiv;
pointer  bres;

string  number;
float   last;
uint    oper;

void calc_add (string n)
{
  number = number + n;
  gtk_entry_set_text (entry, number);
}

void calc_clean ()
{
  number = "";
}

void calc_quit ()
{
  io_write ("Exiting ...\n");
  sys_exit (0); 
}

void bclean_clicked (pointer btn)
{
  oper = 0;
  last = 0;
  number = "";
  gtk_entry_set_text (entry, itostr (0));
}

void bp_clicked (pointer btn)
{
  calc_add (".");
}

void digit_clicked (pointer btn)
{
  if (btn == b[0])
    calc_add ("0");
  if (btn == b[1])
    calc_add ("1");
  if (btn == b[2])
    calc_add ("2");
  if (btn == b[3])
    calc_add ("3");
  if (btn == b[4])
    calc_add ("4");
  if (btn == b[5])
    calc_add ("5");
  if (btn == b[6])
    calc_add ("6");
  if (btn == b[7])
    calc_add ("7");
  if (btn == b[8])
    calc_add ("8");
  if (btn == b[9])
    calc_add ("9");
}

void badd_clicked (pointer btn)
{
  calc_oper ();
  oper = 1;
}

void bmin_clicked (pointer btn)
{
  calc_oper ();
  oper = 2;
}

void bmul_clicked (pointer btn)
{
  calc_oper ();
  oper = 3;
}

void bdiv_clicked (pointer btn)
{
  calc_oper ();
  oper = 4;
}

void bres_clicked (pointer btn)
{
  calc_oper ();
  oper = 10;
}

void calc_oper ()
{
  if (oper == 0)
    last = strtof (number);
  
  if (oper == 1)
    last = last + strtof (number);

  if (oper == 2)
    last = last - strtof (number);

  if (oper == 3)
    last = last * strtof (number);

  if (oper == 4)
    last = last / strtof (number);

  calc_clean ();
  gtk_entry_set_text (entry, ftostr (last));
}

void main (string args[])
{
  io_write ("X Language - Calculator 0.1\n");

  /* Building the interface
   */

  last = 0;
  oper = 0;
  number = "";

  frame = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (frame, "X Language - Calculator 0.2");
  gtk_widget_set_usize (frame, 270, 270);

  fixed = gtk_fixed_new ();
  gtk_container_add (frame, fixed);

  /* Adding GtkEntry
   */
  entry = gtk_entry_new ();
  gtk_widget_set_uposition (entry, 20, 20);
  gtk_widget_set_usize (entry, 230, 22);
  gtk_fixed_put (fixed, entry, 100, 100);

  /* Setup buttons
   */

  b[7] = gtk_button_new_with_label ("7");
  gtk_widget_set_usize (b[7], 30, 30);
  gtk_fixed_put (fixed, b[7], 20, 70);

  b[8] = gtk_button_new_with_label ("8");
  gtk_widget_set_usize (b[8], 30, 30);
  gtk_fixed_put (fixed, b[8], 60, 70);

  b[9] = gtk_button_new_with_label ("9");
  gtk_widget_set_usize (b[9], 30, 30);
  gtk_fixed_put (fixed, b[9], 100, 70);

  b[4] = gtk_button_new_with_label ("4");
  gtk_widget_set_usize (b[4], 30, 30);
  gtk_fixed_put (fixed, b[4], 20, 110);

  b[5] = gtk_button_new_with_label ("5");
  gtk_widget_set_usize (b[5], 30, 30);
  gtk_fixed_put (fixed, b[5], 60, 110);

  b[6] = gtk_button_new_with_label ("6");
  gtk_widget_set_usize (b[6], 30, 30);
  gtk_fixed_put (fixed, b[6], 100, 110);

  b[1] = gtk_button_new_with_label ("1");
  gtk_widget_set_usize (b[1], 30, 30);
  gtk_fixed_put (fixed, b[1], 20, 150);

  b[2] = gtk_button_new_with_label ("2");
  gtk_widget_set_usize (b[2], 30, 30);
  gtk_fixed_put (fixed, b[2], 60, 150);

  b[3] = gtk_button_new_with_label ("3");
  gtk_widget_set_usize (b[3], 30, 30);
  gtk_fixed_put (fixed, b[3], 100, 150);

  b[0] = gtk_button_new_with_label ("0");
  gtk_widget_set_usize (b[0], 30, 30);
  gtk_fixed_put (fixed, b[0], 60, 190);

  bp = gtk_button_new_with_label (".");
  gtk_widget_set_usize (bp, 30, 30);
  gtk_fixed_put (fixed, bp, 100, 190);

  bclean = gtk_button_new_with_label ("C");
  gtk_widget_set_usize (bclean, 30, 30);
  gtk_fixed_put (fixed, bclean, 210, 70);

  badd = gtk_button_new_with_label ("+");
  gtk_widget_set_usize (badd, 30, 30);
  gtk_fixed_put (fixed, badd, 170, 70);

  bmin = gtk_button_new_with_label ("-");
  gtk_widget_set_usize (bmin, 30, 30);
  gtk_fixed_put (fixed, bmin, 170, 110);

  bmul = gtk_button_new_with_label ("*");
  gtk_widget_set_usize (bmul, 30, 30);
  gtk_fixed_put (fixed, bmul, 170, 150);

  bdiv = gtk_button_new_with_label ("/");
  gtk_widget_set_usize (bdiv, 30, 30);
  gtk_fixed_put (fixed, bdiv, 170, 190);

  bres = gtk_button_new_with_label ("=");
  gtk_widget_set_usize (bres, 30, 30);
  gtk_fixed_put (fixed, bres, 210, 190);

  gtk_signal_connect (frame, "destroy", calc_quit, null);

  gtk_signal_connect (b[0], "clicked", digit_clicked, null);
  gtk_signal_connect (b[1], "clicked", digit_clicked, null);
  gtk_signal_connect (b[2], "clicked", digit_clicked, null);
  gtk_signal_connect (b[3], "clicked", digit_clicked, null);
  gtk_signal_connect (b[4], "clicked", digit_clicked, null);
  gtk_signal_connect (b[5], "clicked", digit_clicked, null);
  gtk_signal_connect (b[6], "clicked", digit_clicked, null);
  gtk_signal_connect (b[7], "clicked", digit_clicked, null);
  gtk_signal_connect (b[8], "clicked", digit_clicked, null);
  gtk_signal_connect (b[9], "clicked", digit_clicked, null);

  gtk_signal_connect (bp, "clicked", bp_clicked, null);
  gtk_signal_connect (bclean, "clicked", bclean_clicked, null);

  gtk_signal_connect (badd, "clicked", badd_clicked, null);
  gtk_signal_connect (bmin, "clicked", bmin_clicked, null);
  gtk_signal_connect (bmul, "clicked", bmul_clicked, null);
  gtk_signal_connect (bdiv, "clicked", bdiv_clicked, null);

  gtk_signal_connect (bres, "clicked", bres_clicked, null);

  /* Start the GUI
   */

  /*  bclean_clicked (bclean); */

  gtk_widget_show_all (frame);
  gtk_main ();
}





