/* HTTP server sample
 *
 * # Make a file named 'index.html'
 * # Start this server
 * ./xlc httpd.xc
 *
 * # Start your browser and type 'http://127.0.0.1:8080'
 * # You should see your 'index.html'
 */

pointer sock;
pointer cli_sock;

void http_header_read ()
{
  string cmd;
  
  cmd = net_recvln (cli_sock);
  while (strlen (cmd) != 0)
    {
      io_write ("CMD = ");
      io_write (cmd);
      io_write ("\n");
      
      cmd = net_recvln (cli_sock);
    }
  io_write ("CMD = ");
  io_write (cmd);
  io_write ("\n");
}

void http_data_send ()
{
  pointer file;
  string  data;
  
  file = io_file_open ("index.html", "rt");
  str_setsize (data, 100000);
  io_file_read (data, 1, 100000, file);
  io_file_close (file); 
  
  net_send (cli_sock, data);
}

void main (string args[])
{
  while (1)
    {
      sock = net_socket ();
      io_write ("socket = %d\n", sock);
      io_write ("EPROTONOSUPPORT = %d\n", EPROTONOSUPPORT );
      net_bind (sock, 8080);
      
      net_listen (sock, 2);
      cli_sock = net_accept (sock);
      
      io_write ("Accepting a connection ...\n");

      http_header_read ();
      
      io_write ("Sending data ...\n");
      http_data_send ();
      
      io_write ("Closing the connection ...\n");
      net_close (cli_sock);
      net_close (sock);
    }
}
