/* X Language API - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://xlang.sourceforge.net
 */

ifdef "OS_LINUX" const string MYSQL_LIB = "libmysql.so.6";
ifdef "OS_WIN32" const string MYSQL_LIB = "libmysql.dll";

native_class MySQLField
{
  native_field   cstring name  : 0;
  native_field   cstring table : 4;
  native_field   cstring def   : 8;
}

dynamic MYSQL_LIB "mysql_init"
pointer mysql_init (pointer mysql);

dynamic MYSQL_LIB "mysql_connect"
pointer mysql_connect (pointer mysql, cstring host, cstring user, cstring passwd);

dynamic MYSQL_LIB "mysql_create_db"
uint mysql_create_db (pointer mysql, cstring db);

dynamic MYSQL_LIB "mysql_select_db"
uint mysql_select_db (pointer mysql, cstring db);

dynamic MYSQL_LIB "mysql_query"
uint mysql_query (pointer mysql, cstring query);

dynamic MYSQL_LIB "mysql_use_result"
pointer mysql_use_result (pointer mysql);

dynamic MYSQL_LIB "mysql_fetch_row"
pointer mysql_fetch_row (pointer result);

dynamic MYSQL_LIB "mysql_num_fields"
uint mysql_num_fields (pointer result);

dynamic MYSQL_LIB "mysql_fetch_field"
pointer mysql_fetch_field (pointer result);
