/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlbuiltin.h>
#include <xlclass.h>
#include <xlmain.h>
#include <xlmeth.h>

#include <xapi/xaapi.h>

#include <gtk/gtk.h>
#include <glade/glade.h>

#ifdef USE_WIN32
#include <windows.h>
#endif

xvoid 
xgtk_detach_console ()
{
#ifdef USE_WIN32
  FreeConsole ();
#endif
}

xvoid
xa_gtk_init ()
{
  GtkText          text;
  GtkWidget        widget;
  GtkDialog        dialog;
  GtkFileSelection filesel;

  /* GLib
   */

  xa_api_reg_fnct ("g_get_prgname", g_get_prgname, "cstring", 
		   NULL);

  xa_api_reg_fnct ("g_set_prgname", g_set_prgname, "void", 
		   "cstring", "prgname",
		   NULL);

  xa_api_reg_fnct ("g_getenv", g_getenv, "cstring", 
		   "cstring", "variable",
		   NULL);

  xa_api_reg_fnct ("g_get_user_name", g_get_user_name, "cstring", 
		   NULL);

  xa_api_reg_fnct ("g_get_real_name", g_get_real_name, "cstring", 
		   NULL);

  xa_api_reg_fnct ("g_get_home_dir", g_get_home_dir, "cstring", 
		   NULL);

  xa_api_reg_fnct ("g_get_tmp_dir", g_get_tmp_dir, "cstring", 
		   NULL);

  xa_api_reg_fnct ("g_get_current_dir", g_get_current_dir, "cstring", 
		   NULL);

  xa_api_reg_fnct ("g_basename", g_basename, "cstring", 
		   "cstring", "filename",
		   NULL);

  xa_api_reg_fnct ("g_dirname", g_dirname, "cstring", 
		   "cstring", "filename",
		   NULL);

  /* GList
   */

  xa_api_reg_native_class ("GList", NULL);

  xa_api_reg_fnct ("g_list_append", g_list_append, "pointer",
		   "pointer", "list",
		   "pointer", "data",
		   NULL);

  /* GDK
   */

  xa_api_reg_fnct ("gdk_screen_width", gdk_screen_width, "uint", NULL);
  xa_api_reg_fnct ("gdk_screen_height", gdk_screen_height, "uint", NULL);
 
 
  /* GTK+
   */

  xa_api_reg_const_uint ("GTK_WINDOW_TOPLEVEL", GTK_WINDOW_TOPLEVEL);
  xa_api_reg_const_uint ("GTK_ORIENTATION_HORIZONTAL", GTK_ORIENTATION_HORIZONTAL);
  xa_api_reg_const_uint ("GTK_ORIENTATION_VERTICAL", GTK_ORIENTATION_VERTICAL);
  xa_api_reg_const_uint ("GTK_EXPAND", GTK_EXPAND);
  xa_api_reg_const_uint ("GTK_SHRINK", GTK_SHRINK);
  xa_api_reg_const_uint ("GTK_FILL", GTK_FILL);

  xa_api_reg_fnct ("gtk_detach_console", xgtk_detach_console, "void", NULL);
 
  xa_api_reg_fnct ("gtk_main", gtk_main, "void", NULL);
  xa_api_reg_fnct ("gtk_init", gtk_init, "void",
		   "pointer", "argc",
		   "pointer", "argv",
		   NULL);

  /* GtkAccelLabel (fnct-complete)
   */

  xa_api_reg_native_class ("GtkAccelLabel", NULL);

  xa_api_reg_fnct ("gtk_accel_label_new", gtk_accel_label_new, "pointer",
		   "cstring", "string",
		   NULL);

  xa_api_reg_fnct ("gtk_accel_label_set_accel_widget", gtk_accel_label_set_accel_widget, "void",
		   "pointer", "accel_label",
		   "pointer", "accel_widget",
		   NULL);

  xa_api_reg_fnct ("gtk_accel_label_get_accel_width", gtk_accel_label_get_accel_width, "uint",
		   "pointer", "accel_label",
		   NULL);

  xa_api_reg_fnct ("gtk_accel_label_refetch", gtk_accel_label_refetch, "bool",
		   "pointer", "accel_label",
		   NULL);

  /* GtkAdjustment (fnct-complete)
   */

  xa_api_reg_native_class ("GtkAdjustment", NULL);

  xa_api_reg_fnct ("gtk_adjustment_new", gtk_adjustment_new, "pointer",
		   "float", "value",
		   "float", "lower",
		   "float", "upper",
		   "float", "step_increment",
		   "float", "page_increment",
		   "float", "page_size",
		   NULL);

  xa_api_reg_fnct ("gtk_adjustment_set_value", gtk_adjustment_set_value, "void",
		   "pointer", "adjustment",
		   "float", "value",
		   NULL);

  xa_api_reg_fnct ("gtk_adjustment_clamp_page", gtk_adjustment_clamp_page, "void",
		   "pointer", "adjustment",
		   "float", "lower",
		   "float", "upper",
		   NULL);

  xa_api_reg_fnct ("gtk_adjustment_changed", gtk_adjustment_changed, "void",
		   "pointer", "adjustment",
		   NULL);

  xa_api_reg_fnct ("gtk_adjustment_value_changed", gtk_adjustment_value_changed, "void",
		   "pointer", "adjustment",
		   NULL);


  /* GtkAlignment (fnct-complete)
   */

  xa_api_reg_native_class ("GtkAlignment", NULL);

  xa_api_reg_fnct ("gtk_alignment_new", gtk_alignment_new, "pointer",
		   "float", "xalign",
		   "float", "yalign",
		   "float", "xscale",
		   "float", "yscale",
		   NULL);

  xa_api_reg_fnct ("gtk_alignment_set", gtk_alignment_set, "void",
		   "pointer", "alignment",
		   "float", "xalign",
		   "float", "yalign",
		   "float", "xscale",
		   "float", "yscale",
		   NULL);

  /* GtkArrow (fnct-complete)
   */

  xa_api_reg_native_class ("GtkArrow", NULL);

  xa_api_reg_fnct ("gtk_arrow_new", gtk_arrow_new, "pointer",
		   "uint", "arrow_type",
		   "uint", "shadow_type",
		   NULL);

  xa_api_reg_fnct ("gtk_arrow_set", gtk_arrow_set, "void",
		   "pointer", "arrow",
		   "uint", "arrow_type",
		   "uint", "shadow_type",
		   NULL);

  /* GtkAspectFrame (fnct-complete)
   */

  xa_api_reg_native_class ("GtkAspectFrame", NULL);

  xa_api_reg_fnct ("gtk_aspect_frame_new", gtk_aspect_frame_new, "pointer",
		   "cstring", "label",
		   "float", "xalign",
		   "float", "yalign",
		   "float", "ratio",
		   "int", "obey_child",
		   NULL);

  xa_api_reg_fnct ("gtk_aspect_frame_set", gtk_aspect_frame_set, "void",
		   "pointer", "aspect_frame",
		   "cstring", "label",
		   "float", "xalign",
		   "float", "yalign",
		   "float", "ratio",
		   "int", "obey_child",
		   NULL);

  /* GtkButtonBox (fnct-complete)
   */

  xa_api_reg_native_class ("GtkButtonBox", NULL);

  xa_api_reg_fnct ("gtk_button_box_get_child_size_default", gtk_button_box_get_child_size_default, "void",
		   "pointer", "min_width",
		   "pointer", "min_height",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_get_child_ipadding_default", gtk_button_box_get_child_ipadding_default, "void",
		   "pointer", "ipad_x",
		   "pointer", "ipad_y",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_set_child_size_default", gtk_button_box_set_child_size_default, "void",
		   "int", "min_width",
		   "int", "min_height",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_set_child_ipadding_default", gtk_button_box_set_child_ipadding_default, "void",
		   "int", "ipad_x",
		   "int", "ipad_y",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_get_spacing", gtk_button_box_get_spacing, "int",
		   "pointer", "widget",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_get_layout", gtk_button_box_get_layout, "uint",
		   "pointer", "widget",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_get_child_size", gtk_button_box_get_child_size, "void",
		   "pointer", "widget",
		   "pointer", "min_width",
		   "pointer", "min_height",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_get_child_ipadding", gtk_button_box_get_child_ipadding, "void",
		   "pointer", "widget",
		   "pointer", "ipad_x",
		   "pointer", "ipad_y",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_set_spacing", gtk_button_box_set_spacing, "void",
		   "pointer", "widget",
		   "int", "spacing",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_set_layout", gtk_button_box_set_layout, "void",
		   "pointer", "widget",
		   "uint", "layout_style",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_set_child_size", gtk_button_box_set_child_size, "void",
		   "pointer", "widget",
		   "int", "min_width",
		   "int", "min_height",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_set_child_ipadding", gtk_button_box_set_child_ipadding, "void",
		   "pointer", "widget",
		   "int", "ipad_x",
		   "int", "ipad_y",
		   NULL);

  xa_api_reg_fnct ("gtk_button_box_child_requisition", gtk_button_box_child_requisition, "void",
		   "pointer", "widget",
		   "pointer", "nvis_children",
		   "pointer", "width",
		   "pointer", "height",
		   NULL);

  /* GtkBin (fnct-complete)
   */

  xa_api_reg_native_class ("GtkBin", NULL);

  /* GtkBox (fnct-complete)
   */

  xa_api_reg_native_class ("GtkBox", NULL);

  xa_api_reg_fnct ("gtk_box_pack_start", gtk_box_pack_start, "void",
		   "pointer", "box",
		   "pointer", "widget",
		   "bool", "expand",
		   "bool", "fill",
		   "uint", "padding",
		   NULL);

  xa_api_reg_fnct ("gtk_box_pack_end", gtk_box_pack_end, "void",
		   "pointer", "box",
		   "pointer", "widget",
		   "bool", "expand",
		   "bool", "fill",
		   "uint", "padding",
		   NULL);

  xa_api_reg_fnct ("gtk_box_pack_start_defaults", gtk_box_pack_start_defaults, "void",
		   "pointer", "box",
		   "pointer", "widget",
		   NULL);

  xa_api_reg_fnct ("gtk_box_pack_end_defaults", gtk_box_pack_end_defaults, "void",
		   "pointer", "box",
		   "pointer", "widget",
		   NULL);

  xa_api_reg_fnct ("gtk_box_set_homogeneous", gtk_box_set_homogeneous, "void",
		   "pointer", "box",
		   "bool", "homogeneous",
		   NULL);

  xa_api_reg_fnct ("gtk_box_set_spacing", gtk_box_set_spacing, "void",
		   "pointer", "box",
		   "int", "spacing",
		   NULL);

  xa_api_reg_fnct ("gtk_box_reorder_child", gtk_box_reorder_child, "void",
		   "pointer", "box",
		   "pointer", "child",
		   "int", "position",
		   NULL);

  xa_api_reg_fnct ("gtk_box_query_child_packing", gtk_box_query_child_packing, "void",
		   "pointer", "box",
		   "pointer", "child",
		   "pointer", "expand",
		   "pointer", "fill",
		   "pointer", "padding",
		   "pointer", "pack_type",
		   NULL);

  xa_api_reg_fnct ("gtk_box_set_child_packing", gtk_box_set_child_packing, "void",
		   "pointer", "box",
		   "pointer", "child",
		   "bool", "expand",
		   "bool", "fill",
		   "uint", "padding",
		   "uint", "pack_type",
		   NULL);

  /* GtkButton (fnct-complete)
   */

  xa_api_reg_native_class ("GtkButton", NULL);

  xa_api_reg_fnct ("gtk_button_new", gtk_button_new, "pointer", NULL);
  xa_api_reg_fnct ("gtk_button_new_with_label", gtk_button_new_with_label, "pointer",
		   "cstring", "label",
		   NULL);

  xa_api_reg_fnct ("gtk_button_pressed", gtk_button_pressed, "void",
		   "pointer", "button",
		   NULL);

  xa_api_reg_fnct ("gtk_button_released", gtk_button_released, "void",
		   "pointer", "button",
		   NULL);

  xa_api_reg_fnct ("gtk_button_clicked", gtk_button_clicked, "void",
		   "pointer", "button",
		   NULL);

  xa_api_reg_fnct ("gtk_button_enter", gtk_button_enter, "void",
		   "pointer", "button",
		   NULL);

  xa_api_reg_fnct ("gtk_button_leave", gtk_button_leave, "void",
		   "pointer", "button",
		   NULL);

  xa_api_reg_fnct ("gtk_button_set_relief", gtk_button_set_relief, "void",
		   "pointer", "button",
		   "uint", "newstyle",
		   NULL);

  xa_api_reg_fnct ("gtk_button_get_relief", gtk_button_get_relief, "uint",
		   "pointer", "button",
		   NULL);


  /* GtkCalendar (fnct-complete)
   */

  xa_api_reg_native_class ("GtkCalendar", NULL);

  xa_api_reg_fnct ("gtk_calendar_new", gtk_calendar_new, "pointer", NULL);

  xa_api_reg_fnct ("gtk_calendar_select_month", gtk_calendar_select_month, "int", 
		   "pointer", "calendar",
		   "uint", "month",
		   "uint", "year",
		   NULL);

  xa_api_reg_fnct ("gtk_calendar_select_day", gtk_calendar_select_day, "void", 
		   "pointer", "calendar",
		   "uint", "day",
		   NULL);

  xa_api_reg_fnct ("gtk_calendar_mark_day", gtk_calendar_mark_day, "int", 
		   "pointer", "calendar",
		   "uint", "day",
		   NULL);

  xa_api_reg_fnct ("gtk_calendar_unmark_day", gtk_calendar_unmark_day, "int", 
		   "pointer", "calendar",
		   "uint", "day",
		   NULL);

  xa_api_reg_fnct ("gtk_calendar_clear_marks", gtk_calendar_clear_marks, "void", 
		   "pointer", "calendar",
		   NULL);

  xa_api_reg_fnct ("gtk_calendar_display_options", gtk_calendar_display_options, "void", 
		   "pointer", "calendar",
		   "uint", "flags",
		   NULL);

  xa_api_reg_fnct ("gtk_calendar_get_date", gtk_calendar_get_date, "void", 
		   "pointer", "year",
		   "pointer", "month",
		   "pointer", "day",
		   NULL);

  xa_api_reg_fnct ("gtk_calendar_freeze", gtk_calendar_freeze, "void", 
		   "pointer", "calendar",
		   NULL);

  xa_api_reg_fnct ("gtk_calendar_thaw", gtk_calendar_thaw, "void", 
		   "pointer", "calendar",
		   NULL);

  /* GtkCheckButton (fnct-complete)
   */

  xa_api_reg_native_class ("GtkCheckButton", NULL);

  xa_api_reg_fnct ("gtk_check_button_new", gtk_check_button_new, "pointer", NULL);

  xa_api_reg_fnct ("gtk_check_button_new_with_label", gtk_check_button_new_with_label, "pointer",
		   "cstring", "label",
		   NULL);


  /* GtkCheckMenuItem (fnct-complete)
   */

  xa_api_reg_native_class ("GtkCheckMenuItem", NULL);

  xa_api_reg_fnct ("gtk_check_menu_item_new", gtk_check_menu_item_new, "pointer", NULL);

  xa_api_reg_fnct ("gtk_check_menu_item_new_with_label", gtk_check_menu_item_new_with_label, "pointer",
		   "cstring", "label",
		   NULL);

  xa_api_reg_fnct ("gtk_check_menu_item_set_active", gtk_check_menu_item_set_active, "void", 
		   "pointer", "check_menu_item",
		   "bool", "is_active",
		   NULL);

  xa_api_reg_fnct ("gtk_check_menu_item_set_show_toggle", gtk_check_menu_item_set_show_toggle, "void", 
		   "pointer", "check_menu_item",
		   "bool", "always",
		   NULL);

  xa_api_reg_fnct ("gtk_check_menu_item_toggled", gtk_check_menu_item_toggled, "void", 
		   "pointer", "check_menu_item",
		   NULL);


  /* GtkCList (fnct-complete)
   */

  xa_api_reg_native_class ("GtkCList", NULL);

  xa_api_reg_fnct ("gtk_clist_construct", gtk_clist_construct, "void", 
		   "pointer", "clist",
		   "int", "columns",
		   "pointer", "titles",
		   NULL); 

  xa_api_reg_fnct ("gtk_clist_new", gtk_clist_new, "pointer", 
		   "int", "columns",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_new_with_titles", gtk_clist_new_with_titles, "pointer", 
		   "int", "columns",
		   "pointer", "titles",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_shadow_type", gtk_clist_set_shadow_type, "void", 
		   "pointer", "clist",
		   "uint", "type",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_selection_mode", gtk_clist_set_selection_mode, "void", 
		   "pointer", "clist",
		   "uint", "mode",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_freeze", gtk_clist_freeze, "void", 
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_thaw", gtk_clist_thaw, "void", 
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_column_titles_show", gtk_clist_column_titles_show, "void",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_column_titles_hide", gtk_clist_column_titles_hide, "void",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_column_title_active", gtk_clist_column_title_active, "void",
		   "pointer", "clist",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_column_title_passive", gtk_clist_column_title_passive, "void",
		   "pointer", "clist",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_column_titles_active", gtk_clist_column_titles_active, "void",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_column_titles_passive", gtk_clist_column_titles_passive, "void",
		   "pointer", "clist",
		   NULL);
  
  xa_api_reg_fnct ("gtk_clist_set_column_title", gtk_clist_set_column_title, "void",
		   "pointer", "clist",
		   "int", "column",
		   "cstring", "title",
		   NULL);
  
  xa_api_reg_fnct ("gtk_clist_set_column_widget", gtk_clist_set_column_widget, "void",
		   "pointer", "clist",
		   "int", "column",
		   "pointer", "widget",
		   NULL);
 
  xa_api_reg_fnct ("gtk_clist_set_column_justification", gtk_clist_set_column_justification, "void",
		   "pointer", "clist",
		   "int", "column",
		   "uint", "justification",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_column_visibility", gtk_clist_set_column_visibility, "void",
		   "pointer", "clist",
		   "int", "column",
		   "bool", "visible",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_column_resizeable", gtk_clist_set_column_resizeable, "void",
		   "pointer", "clist",
		   "int", "column",
		   "bool", "resizeable",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_column_auto_resize", gtk_clist_set_column_auto_resize, "void",
		   "pointer", "clist",
		   "int", "column",
		   "bool", "auto_resize",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_optimal_column_width", gtk_clist_optimal_column_width, "int",
		   "pointer", "clist",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_column_width", gtk_clist_set_column_width, "void",
		   "pointer", "clist",
		   "int", "column",
		   "int", "width",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_column_min_width", gtk_clist_set_column_min_width, "void",
		   "pointer", "clist",
		   "int", "column",
		   "int", "min_width",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_column_max_width", gtk_clist_set_column_max_width, "void",
		   "pointer", "clist",
		   "int", "column",
		   "int", "max_width",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_row_height", gtk_clist_set_row_height, "void",
		   "pointer", "clist",
		   "uint", "height",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_moveto", gtk_clist_moveto, "void",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   "float", "row_align",
		   "float", "col_align",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_row_is_visible", gtk_clist_row_is_visible, "uint",
		   "pointer", "clist",
		   "int", "row",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_cell_type", gtk_clist_get_cell_type, "uint",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_text", gtk_clist_set_text, "void",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   "cstring", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_text", gtk_clist_get_text, "int",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   "pointer", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_pixmap", gtk_clist_set_pixmap, "void",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   "pointer", "pixmap",
		   "pointer", "mask",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_pixmap", gtk_clist_get_pixmap, "int",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   "pointer", "pixmap",
		   "pointer", "mask",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_pixtext", gtk_clist_set_pixtext, "void",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   "cstring", "text",
		   "uint", "spacing",
		   "pointer", "pixmap",
		   "pointer", "mask",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_pixtext", gtk_clist_get_pixtext, "int",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   "pointer", "text",
		   "pointer", "spacing",
		   "pointer", "pixmap",
		   "pointer", "mask",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_foreground", gtk_clist_set_foreground, "void",
		   "pointer", "clist",
		   "int", "row",
		   "pointer", "color",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_background", gtk_clist_set_background, "void",
		   "pointer", "clist",
		   "int", "row",
		   "pointer", "color",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_cell_style", gtk_clist_set_cell_style, "void",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   "pointer", "style",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_cell_style", gtk_clist_get_cell_style, "pointer",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_row_style", gtk_clist_set_row_style, "void",
		   "pointer", "clist",
		   "int", "row",
		   "pointer", "style",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_row_style", gtk_clist_get_row_style, "pointer",
		   "pointer", "clist",
		   "int", "row",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_shift", gtk_clist_set_shift, "void",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   "int", "vertical",
		   "int", "horizontal",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_selectable", gtk_clist_set_selectable, "void",
		   "pointer", "clist",
		   "int", "row",
		   "bool", "selectable",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_selectable", gtk_clist_get_selectable, "bool",
		   "pointer", "clist",
		   "int", "row",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_prepend", gtk_clist_prepend, "int",
		   "pointer", "clist",
		   "pointer", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_append", gtk_clist_append, "int",
		   "pointer", "clist",
		   "pointer", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_insert", gtk_clist_insert, "int",
		   "pointer", "clist",
		   "int", "row",
		   "pointer", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_remove", gtk_clist_remove, "void",
		   "pointer", "clist",
		   "int", "row",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_row_data", gtk_clist_set_row_data, "void",
		   "pointer", "clist",
		   "int", "row",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_row_data_full", gtk_clist_set_row_data_full, "void",
		   "pointer", "clist",
		   "int", "row",
		   "pointer", "data",
		   "pointer", "destroy",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_row_data", gtk_clist_get_row_data, "pointer",
		   "pointer", "clist",
		   "int", "row",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_find_row_from_data", gtk_clist_find_row_from_data, "int",
		   "pointer", "clist",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_select_row", gtk_clist_select_row, "void",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_unselect_row", gtk_clist_unselect_row, "void",
		   "pointer", "clist",
		   "int", "row",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_undo_selection", gtk_clist_undo_selection, "void",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_clear", gtk_clist_clear, "void",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_selection_info", gtk_clist_get_selection_info, "int",
		   "pointer", "clist",
		   "int", "x",
		   "int", "y",
		   "pointer", "row",
		   "pointer", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_select_all", gtk_clist_select_all, "void",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_unselect_all", gtk_clist_unselect_all, "void",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_swap_rows", gtk_clist_swap_rows, "void",
		   "pointer", "clist",
		   "int", "row1",
		   "int", "row2",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_compare_func", gtk_clist_set_compare_func, "void",		  
		   "pointer", "clist",
		   "pointer", "cmp_func",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_sort_column", gtk_clist_set_sort_column, "void",
		   "pointer", "clist",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_sort_type", gtk_clist_set_sort_type, "void",
		   "pointer", "clist",
		   "uint", "sort_type",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_sort", gtk_clist_sort, "void",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_auto_sort", gtk_clist_set_auto_sort, "void",
		   "pointer", "clist",
		   "bool", "auto_sort",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_columns_autosize", gtk_clist_columns_autosize, "uint",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_column_title", gtk_clist_get_column_title, "cstring",
		   "pointer", "clist",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_column_widget", gtk_clist_get_column_widget, "pointer",
		   "pointer", "clist",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_hadjustment", gtk_clist_get_hadjustment, "pointer",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_get_vadjustment", gtk_clist_get_vadjustment, "pointer",
		   "pointer", "clist",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_row_move", gtk_clist_row_move, "void",
		   "pointer", "clist",
		   "int", "source_row",
		   "int", "dest_row",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_button_actions", gtk_clist_set_button_actions, "void",
		   "pointer", "clist",
		   "uint", "button",
		   "uchar", "button_actions",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_sget_hadjustment", gtk_clist_set_hadjustment, "void",
		   "pointer", "clist",
		   "pointer", "adjustment",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_vadjustment", gtk_clist_set_vadjustment, "void",
		   "pointer", "clist",
		   "pointer", "adjustment",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_reorderable", gtk_clist_set_reorderable, "void",
		   "pointer", "clist",
		   "bool", "reorderable",
		   NULL);

  xa_api_reg_fnct ("gtk_clist_set_use_drag_icons", gtk_clist_set_use_drag_icons, "void",
		   "pointer", "clist",
		   "bool", "use_icons",
		   NULL);

  /* GtkColorSelection (fnct-complete)
   */

  xa_api_reg_native_class ("GtkColorSelection", NULL);

  xa_api_reg_fnct ("gtk_color_selection_new", gtk_color_selection_new, "pointer", NULL);

  xa_api_reg_fnct ("gtk_color_selection_set_update_policy", gtk_color_selection_set_update_policy, "void",
		   "pointer", "colorsel",
		   "uint", "policy",
		   NULL);

  xa_api_reg_fnct ("gtk_color_selection_set_opacity", gtk_color_selection_set_opacity, "void",
		   "pointer", "colorsel",
		   "int", "use_opacity",
		   NULL);

  xa_api_reg_fnct ("gtk_color_selection_set_color", gtk_color_selection_set_color, "void",
		   "pointer", "colorsel",
		   "pointer", "color",
		   NULL);

  xa_api_reg_fnct ("gtk_color_selection_get_color", gtk_color_selection_get_color, "void",
		   "pointer", "colorsel",
		   "pointer", "color",
		   NULL);

  /* GtkColorSelectionDialog (fnct-complete)
   */

  xa_api_reg_native_class ("GtkColorSelectionDialog", NULL);

  xa_api_reg_fnct ("gtk_color_selection_dialog_new", gtk_color_selection_dialog_new, "pointer",
		   "cstring", "title",
		   NULL);

  /* GtkCombo (fnct-complete)
   */

  xa_api_reg_native_class ("GtkCombo", NULL);

  xa_api_reg_fnct ("gtk_combo_new", gtk_combo_new, "pointer",
		   NULL);

  xa_api_reg_fnct ("gtk_combo_set_popdown_strings", gtk_combo_set_popdown_strings, "void",
		   "pointer", "combo",
		   "pointer", "strings",
		   NULL);

  xa_api_reg_fnct ("gtk_combo_set_value_in_list", gtk_combo_set_value_in_list, "void",
		   "pointer", "combo",
		   "int", "val",
		   "int", "ok_if_empty",
		   NULL);

  xa_api_reg_fnct ("gtk_combo_set_use_arrowd", gtk_combo_set_use_arrows, "void",
		   "pointer", "combo",
		   "int", "val",
		   NULL);

  xa_api_reg_fnct ("gtk_combo_set_use_arrows_always", gtk_combo_set_use_arrows_always, "void",
		   "pointer", "combo",
		   "int", "val",
		   NULL);

  xa_api_reg_fnct ("gtk_combo_set_case_sensitive", gtk_combo_set_case_sensitive, "void",
		   "pointer", "combo",
		   "int", "val",
		   NULL);

  xa_api_reg_fnct ("gtk_combo_set_item_string", gtk_combo_set_item_string, "void",
		   "pointer", "combo",
		   "pointer", "item",
		   "cstring", "item_value",
		   NULL);

  xa_api_reg_fnct ("gtk_combo_disable_activate", gtk_combo_disable_activate, "void",
		   "pointer", "combo",
		   NULL);

  /* GtkContainer (fnct-complete)
   */

  xa_api_reg_native_class ("GtkContainer", NULL);

  xa_api_reg_fnct ("gtk_container_add", gtk_container_add, "void",
		   "pointer", "container",
		   "pointer", "widget",
		   NULL);

  xa_api_reg_fnct ("gtk_container_remove", gtk_container_remove, "void",
		   "pointer", "container",
		   "pointer", "widget",
		   NULL);

  xa_api_reg_fnct ("gtk_container_set_resize_mode", gtk_container_set_resize_mode, "void",
		   "pointer", "container",
		   "uint", "resize_mode",
		   NULL);

  xa_api_reg_fnct ("gtk_container_check_resize", gtk_container_check_resize, "void",
		   "pointer", "container",
		   NULL);

  xa_api_reg_fnct ("gtk_container_foreach", gtk_container_foreach, "void",
		   "pointer", "container",
		   "pointer", "callback",
		   "pointer", "callback_data",
		   NULL);

  xa_api_reg_fnct ("gtk_container_foreach_full", gtk_container_foreach_full, "void",
		   "pointer", "container",
		   "pointer", "callback",
		   "pointer", "marshal",
		   "pointer", "callback_data",
		   "pointer", "notify",
		   NULL);

  xa_api_reg_fnct ("gtk_container_children", gtk_container_children, "pointer",
		   "pointer", "container",
		   NULL);

  xa_api_reg_fnct ("gtk_container_focus", gtk_container_focus, "int",
		   "pointer", "container",
		   "uint", "direction",
		   NULL);

  xa_api_reg_fnct ("gtk_container_set_focus_child", gtk_container_set_focus_child, "void",
		   "pointer", "container",
		   "pointer", "widget",
		   NULL);

  xa_api_reg_fnct ("gtk_container_set_focus_vadjustment", gtk_container_set_focus_vadjustment, "void",
		   "pointer", "container",
		   "pointer", "adjustment",
		   NULL);

  xa_api_reg_fnct ("gtk_container_set_focus_hadjustment", gtk_container_set_focus_hadjustment, "void",
		   "pointer", "container",
		   "pointer", "adjustment",
		   NULL);

  xa_api_reg_fnct ("gtk_container_register_toplevel", gtk_container_register_toplevel, "void",
		   "pointer", "container",
		   NULL);

  xa_api_reg_fnct ("gtk_container_unregister_toplevel", gtk_container_unregister_toplevel, "void",
		   "pointer", "container",
		   NULL);

  xa_api_reg_fnct ("gtk_container_resize_children", gtk_container_resize_children, "void",
		   "pointer", "container",
		   NULL);

  xa_api_reg_fnct ("gtk_container_child_type", gtk_container_child_type, "uint",
		   "pointer", "container",
		   NULL);

  xa_api_reg_fnct ("gtk_container_add_child_arg_type", gtk_container_add_child_arg_type, "void",
		   "cstring", "arg_name",
		   "uint", "arg_type",
		   "uint", "arg_flags",
		   "uint", "arg_id",
		   NULL);

  xa_api_reg_fnct ("gtk_container_query_child_args", gtk_container_query_child_args, "pointer",
		   "uint", "class_type",
		   "pointer", "arg_flags",
		   "pointer", "n_args",
		   NULL);

  xa_api_reg_fnct ("gtk_container_child_getv", gtk_container_child_getv, "void",
		   "pointer", "container",
		   "pointer", "child",
		   "uint", "n_args",
		   "pointer", "args",
		   NULL);

  xa_api_reg_fnct ("gtk_container_child_setv", gtk_container_child_setv, "void",
		   "pointer", "container",
		   "pointer", "child",
		   "uint", "n_args",
		   "pointer", "args",
		   NULL);

  xa_api_reg_fnct ("gtk_container_add_with_args", gtk_container_add_with_args, "void",
		   "pointer", "container",
		   "pointer", "widget",  
		   "cstring", "first_arg_name",
		   "...",
		   NULL);

  xa_api_reg_fnct ("gtk_container_addv", gtk_container_addv, "void",
		   "pointer", "container",
		   "pointer", "widget",
		   "uint", "n_args",
		   "pointer", "args",
		   NULL);

  xa_api_reg_fnct ("gtk_container_child_set", gtk_container_child_set, "void",
		   "pointer", "container",
		   "pointer", "widget",  
		   "cstring", "first_arg_name",
		   "...",
		   NULL);

  xa_api_reg_fnct ("gtk_container_queue_resize", gtk_container_queue_resize, "void",
		   "pointer", "container",
		   NULL);

  xa_api_reg_fnct ("gtk_container_clear_resize_widgets", gtk_container_clear_resize_widgets, "void",
		   "pointer", "container",
		   NULL);

  xa_api_reg_fnct ("gtk_container_arg_set", gtk_container_arg_set, "void",
		   "pointer", "container",
		   "pointer", "child",
		   "pointer", "arg",
		   "pointer", "info",
		   NULL);

  xa_api_reg_fnct ("gtk_container_arg_get", gtk_container_arg_get, "void",
		   "pointer", "container",
		   "pointer", "child",
		   "pointer", "arg",
		   "pointer", "info",
		   NULL);

  /* NOTE: Not yet a symbol on Win32

    xa_api_reg_fnct ("gtk_container_child_args_collect", gtk_container_child_args_collect, "cstring",
    "uint", "object_type",
    "pointer", "arg_list_p",
    "pointer", "info_list_p",
    "cstring", "first_arg_name",
    "...",
    NULL);
  */

  xa_api_reg_fnct ("gtk_container_child_arg_get_info", gtk_container_child_arg_get_info, "cstring",
		   "uint", "object_type",
		   "cstring", "arg_name",
		   "pointer", "info_p",
		   NULL);

  xa_api_reg_fnct ("gtk_container_forall", gtk_container_forall, "void",
		   "pointer", "container",
		   "pointer", "callback",
		   "pointer", "callback_data",
		   NULL);

  xa_api_reg_fnct ("gtk_container_child_composite_name", gtk_container_child_composite_name, "cstring",
		   "pointer", "container",
		   "pointer", "child",
		   NULL);

  xa_api_reg_fnct ("gtk_container_get_toplevels", gtk_container_get_toplevels, "pointer", NULL);

  xa_api_reg_fnct ("gtk_container_set_border_width", gtk_container_set_border_width, "void", 
		   "pointer", "container",
		   "uint", "border_width",
		   NULL);

  /* GtkCTree (fnct-complete)
   */

  xa_api_reg_native_class ("GtkCTree", NULL);
  xa_api_reg_native_class ("GtkCTreeRow", NULL);
  xa_api_reg_native_class ("GtkCTreeNode", NULL);

  xa_api_reg_fnct ("gtk_ctree_construct", gtk_ctree_construct, "void", 
		   "pointer", "ctree",
		   "int", "columns",
		   "int", "tree_column",
		   "pointer", "titles",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_new_with_titles", gtk_ctree_new_with_titles, "pointer", 
		   "int", "columns",
		   "int", "tree_column",
		   "pointer", "titles",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_new", gtk_ctree_new, "pointer", 
		   "int", "columns",
		   "int", "tree_column",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_insert_node", gtk_ctree_insert_node, "pointer", 
		   "pointer", "ctree",
		   "pointer", "parent",
		   "pointer", "sibling",
		   "pointer", "text",
		   "uint", "spacing",
		   "pointer", "pixmap_closed",
		   "pointer", "mask_closed",
		   "pointer", "pixmap_opened",
		   "hanlde", "mask_opened",
		   "bool", "is_leaf",
		   "bool", "expanded",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_remove_node", gtk_ctree_remove_node, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_insert_gnode", gtk_ctree_insert_gnode, "pointer", 
		   "pointer", "ctree",
		   "pointer", "parent",
		   "pointer", "sibling",
		   "hanlde", "gnode",
		   "pointer", "func",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_export_to_gnode", gtk_ctree_export_to_gnode, "pointer", 
		   "pointer", "ctree",
		   "pointer", "parent",
		   "pointer", "sibling",
		   "pointer", "node",
		   "pointer", "func",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_post_recursive", gtk_ctree_post_recursive, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "func",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_post_recursive_to_depth", gtk_ctree_post_recursive_to_depth, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "depth",
		   "pointer", "func",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_pre_recursive", gtk_ctree_pre_recursive, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "func",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_pre_recursive_to_depth", gtk_ctree_pre_recursive_to_depth, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "depth",
		   "pointer", "func",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_is_viewable", gtk_ctree_is_viewable, "bool", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_last", gtk_ctree_last, "pointer", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_find_node_ptr", gtk_ctree_find_node_ptr, "pointer", 
		   "pointer", "ctree",
		   "pointer", "ctree_row",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_find", gtk_ctree_find, "bool", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "child",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_is_ancestor", gtk_ctree_is_ancestor, "bool", 
		   "hanlde", "ctree",
		   "pointer", "node",
		   "pointer", "child",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_find_by_row_data", gtk_ctree_find_by_row_data, "pointer", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_find_all_by_row_data", gtk_ctree_find_all_by_row_data, "pointer", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_find_by_row_data_custom", gtk_ctree_find_by_row_data_custom, "pointer", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "data",
		   "pointer", "func",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_find_all_by_row_data_custom", gtk_ctree_find_all_by_row_data_custom, "pointer", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "data",
		   "pointer", "func",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_is_hot_spot", gtk_ctree_is_hot_spot, "bool", 
		   "pointer", "ctree",
		   "int", "x",
		   "int", "y",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_move", gtk_ctree_move, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "new_parent",
		   "pointer", "new_sibling",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_expand", gtk_ctree_expand, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_expand_recursive", gtk_ctree_expand_recursive, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_expand_to_depth", gtk_ctree_expand_to_depth, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "depth",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_collapse", gtk_ctree_collapse, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_collapse_recursive", gtk_ctree_collapse_recursive, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_collapse_to_depth", gtk_ctree_collapse_to_depth, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "depth",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_toggle_expansion", gtk_ctree_toggle_expansion, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_toggle_expansion_recursive", gtk_ctree_toggle_expansion_recursive, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_select", gtk_ctree_select, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_select_recursive", gtk_ctree_select_recursive, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_unselect", gtk_ctree_unselect, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_unselect_recursive", gtk_ctree_unselect_recursive, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_real_select_recursive", gtk_ctree_real_select_recursive, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "state",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_text", gtk_ctree_node_set_text, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   "cstring", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_pixmap", gtk_ctree_node_set_pixmap, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   "pointer", "pixmap",
		   "pointer", "mask",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_pixtext", gtk_ctree_node_set_pixtext, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   "cstring", "text",
		   "uint", "spacing",
		   "pointer", "pixmap",
		   "pointer", "mask",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_set_node_info", gtk_ctree_set_node_info, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "cstring", "text",
		   "uint", "spacing",
		   "pointer", "pixmap_closed",
		   "pointer", "mask_closed",
		   "pointer", "pixmap_opened",
		   "pointer", "mask_opened",
		   "bool", "is_leaf",
		   "bool", "expanded",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_shift", gtk_ctree_node_set_shift, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   "int", "vertical",
		   "int", "horizontal",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_selectable", gtk_ctree_node_set_selectable, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "bool", "selectable",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_get_selectable", gtk_ctree_node_get_selectable, "bool", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_get_cell_type", gtk_ctree_node_get_cell_type, "uint", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_get_text", gtk_ctree_node_get_text, "int", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   "pointer", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_get_pixmap", gtk_ctree_node_get_pixmap, "int", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   "pointer", "pixmap",
		   "pointer", "mask",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_get_pixtext", gtk_ctree_node_get_pixtext, "int", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   "pointer", "text",
		   "pointer", "spacing",
		   "pointer", "pixmap",
		   "pointer", "mask",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_get_node_info", gtk_ctree_get_node_info, "int", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "text",
		   "pointer", "spacing",
		   "pointer", "pixmap_closed",
		   "pointer", "mask_closed",
		   "pointer", "pixmap_opened",
		   "pointer", "mask_opened",
		   "pointer", "is_leaf",
		   "pointer", "expanded",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_row_style", gtk_ctree_node_set_row_style, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "style",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_get_row_style", gtk_ctree_node_get_row_style, "pointer", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_cell_style", gtk_ctree_node_set_cell_style, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   "pointer", "style",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_get_cell_style", gtk_ctree_node_get_cell_style, "pointer", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_foreground", gtk_ctree_node_set_foreground, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "color",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_background", gtk_ctree_node_set_background, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "color",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_row_data", gtk_ctree_node_set_row_data, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "data",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_set_row_data_full", gtk_ctree_node_set_row_data_full, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "pointer", "data",
		   "pointer", "destroy",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_get_row_data", gtk_ctree_node_get_row_data, "pointer", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_moveto", gtk_ctree_node_moveto, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   "int", "column",
		   "float", "row_align",
		   "float", "col_align",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_is_visible", gtk_ctree_node_is_visible, "uint", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_set_indent", gtk_ctree_set_indent, "void", 
		   "pointer", "ctree",
		   "int", "indent",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_set_spacing", gtk_ctree_set_spacing, "void", 
		   "pointer", "ctree",
		   "int", "spacing",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_set_line_style", gtk_ctree_set_line_style, "void", 
		   "pointer", "ctree",
		   "uint", "line_style",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_set_expander_style", gtk_ctree_set_expander_style, "void", 
		   "pointer", "ctree",
		   "uint", "expander_style",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_set_drag_compare_func", gtk_ctree_set_drag_compare_func, "void", 
		   "pointer", "ctree",
		   "pointer", "cmp_func",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_sort_node", gtk_ctree_sort_node, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_sort_recursive", gtk_ctree_sort_recursive, "void", 
		   "pointer", "ctree",
		   "pointer", "node",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_node_nth", gtk_ctree_node_nth, "pointer", 
		   "pointer", "ctree",
		   "uint", "row",
		   NULL);

  xa_api_reg_fnct ("gtk_ctree_set_show_stub", gtk_ctree_set_show_stub, "void", 
		   "pointer", "ctree",
		   "bool", "show_stub",
		   NULL);

  /* GtkCurve (fnct-complete)
   */

  xa_api_reg_native_class ("GtkCurve", NULL);

  xa_api_reg_fnct ("gtk_curve_new", gtk_curve_new, "pointer", NULL);

  xa_api_reg_fnct ("gtk_curve_reset", gtk_curve_reset, "void", 
		   "pointer", "curve",
		   NULL);

  xa_api_reg_fnct ("gtk_curve_set_gamma", gtk_curve_set_gamma, "void", 
		   "pointer", "curve",
		   "float", "gamma",
		   NULL);

  xa_api_reg_fnct ("gtk_curve_set_range", gtk_curve_set_range, "void", 
		   "float", "min_x",
		   "float", "max_x",
		   "float", "min_y",
		   "flaot", "max_y",
		   NULL);

  xa_api_reg_fnct ("gtk_curve_get_vector", gtk_curve_get_vector, "void", 
		   "pointer", "curve",
		   "int", "veclen",
		   "pointer", "vector",
		   NULL);

  xa_api_reg_fnct ("gtk_curve_set_vector", gtk_curve_set_vector, "void", 
		   "pointer", "curve",
		   "int", "veclen",
		   "pointer", "vector",
		   NULL);

  xa_api_reg_fnct ("gtk_curve_set_curve_type", gtk_curve_set_curve_type, "void", 
		   "pointer", "curve",
		   "uint", "type",
		   NULL);

  /* GtkData (fnct-complete)
   */

  xa_api_reg_native_class ("GtkData", 
			   NULL);

  /* GtkDialog (fnct-complete)
   */

  xa_api_reg_native_class ("GtkDialog", 
			   "pointer", "window", FIELD_POS(dialog, window),
			   "pointer", "vbox", FIELD_POS(dialog, vbox),
			   "pointer", "action_area", FIELD_POS(dialog, action_area),
			   NULL);

  xa_api_reg_fnct ("gtk_dialog_new", gtk_dialog_new, "pointer", NULL);

  /* GtkDrawingArea (fnct-complete)
   */

  xa_api_reg_native_class ("GtkDrawingArea", NULL);

  xa_api_reg_fnct ("gtk_drawing_area_new", gtk_drawing_area_new, "pointer", NULL);

  xa_api_reg_fnct ("gtk_drawing_area_size", gtk_drawing_area_size, "void", 
		   "pointer", "darea",
		   "int", "width",
		   "int", "height",
		   NULL);

  /* GtkEditable (fnct-complete)
   */

  xa_api_reg_native_class ("GtkEditable", NULL);

  xa_api_reg_fnct ("gtk_editable_select_region", gtk_editable_select_region, "void",
		   "pointer", "editable",
		   "int", "start",
		   "int", "end",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_insert_text", gtk_editable_insert_text, "void",
		   "pointer", "editable",
		   "cstring", "new_text",
		   "int", "new_text_length",
		   "pointer", "position",
		   NULL);
  
  xa_api_reg_fnct ("gtk_editable_delete_text", gtk_editable_delete_text, "void",
		   "pointer", "editable",
		   "uint", "start_pos",
		   "uint", "end_pos",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_get_chars", gtk_editable_get_chars, "cstring",
		   "pointer", "editable",
		   "uint", "start_pos",
		   "uint", "end_pos",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_cut_clipboard", gtk_editable_cut_clipboard, "void",
		   "pointer", "editable",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_copy_clipboard", gtk_editable_copy_clipboard, "void",
		   "pointer", "editable",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_paste_clipboard", gtk_editable_paste_clipboard, "void",
		   "pointer", "editable",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_claim_selection", gtk_editable_claim_selection, "void",
		   "pointer", "editable",
		   "bool", "claim",
		   "uint", "time",
		   NULL);
 
  xa_api_reg_fnct ("gtk_editable_delete_selection", gtk_editable_delete_selection, "void",
		   "pointer", "editable",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_changed", gtk_editable_changed, "void",
		   "pointer", "editable",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_set_position", gtk_editable_set_position, "void",
		   "pointer", "editable",
		   "uint", "position",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_get_position", gtk_editable_get_position, "uint",
		   "pointer", "editable",
		   NULL);

  xa_api_reg_fnct ("gtk_editable_set_editable", gtk_editable_set_editable, "void",
		   "pointer", "editable",
		   "bool", "is_editable",
		   NULL);

  /* GtkEntry (fnct-complete)
   */

  xa_api_reg_native_class ("GtkEntry", NULL);

  xa_api_reg_fnct ("gtk_entry_new", gtk_entry_new, "pointer", NULL);

  xa_api_reg_fnct ("gtk_entry_new_with_max_length", gtk_entry_new_with_max_length, "pointer", 
		   "uint", "max",
		   NULL);

  xa_api_reg_fnct ("gtk_entry_set_text", gtk_entry_set_text, "void",
		   "pointer", "entry",
		   "cstring", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_entry_append_text", gtk_entry_append_text, "void",
		   "pointer", "entry",
		   "cstring", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_entry_prepend_text", gtk_entry_prepend_text, "void",
		   "pointer", "entry",
		   "cstring", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_entry_set_position", gtk_entry_set_position, "void",
		   "pointer", "entry",
		   "int", "position",
		   NULL);

  xa_api_reg_fnct ("gtk_entry_get_text", gtk_entry_get_text, "cstring",
		   "pointer", "entry",
		   NULL);

  xa_api_reg_fnct ("gtk_entry_select_region", gtk_entry_select_region, "void",
		   "pointer", "entry",
		   "int", "start",
		   "int", "end",
		   NULL);

  xa_api_reg_fnct ("gtk_entry_set_visibility", gtk_entry_set_visibility, "void",
		   "pointer", "entry",
		   "bool", "visible",
		   NULL);

  xa_api_reg_fnct ("gtk_entry_set_editable", gtk_entry_set_editable, "void",
		   "pointer", "entry",
		   "bool", "editable",
		   NULL);

  xa_api_reg_fnct ("gtk_entry_set_max_length", gtk_entry_set_max_length, "void",
		   "pointer", "entry",
		   "uint", "max",
		   NULL);

  /* GtkEventBox (fnct-complete)
   */

  xa_api_reg_native_class ("GtkEventBox", NULL);

  xa_api_reg_fnct ("gtk_event_box_new", gtk_event_box_new, "pointer", NULL);

  /* GtkFileSelection (complete)
   */

  xa_api_reg_native_class ("GtkFileSelection", 
			   "pointer", "fileop_dialog", FIELD_POS(filesel, fileop_dialog),
			   "pointer", "dir_list", FIELD_POS(filesel, dir_list),
			   "pointer", "file_list", FIELD_POS(filesel, file_list),
			   "pointer", "ok_button", FIELD_POS(filesel, ok_button),
			   "pointer", "cancel_button", FIELD_POS(filesel, cancel_button),
			   "pointer", "history_pulldown", FIELD_POS(filesel, history_pulldown),
			   "pointer", "fileop_c_dir", FIELD_POS(filesel, fileop_c_dir),
			   "pointer", "fileop_del_file", FIELD_POS(filesel, fileop_del_file),
			   "pointer", "fileop_ren_file", FIELD_POS(filesel, fileop_ren_file),
			   NULL);

  xa_api_reg_fnct ("gtk_file_selection_new", gtk_file_selection_new, "pointer",
		   "cstring", "filename",
		   NULL);

  xa_api_reg_fnct ("gtk_file_selection_set_filename", gtk_file_selection_set_filename, "void",
		   "pointer", "filesel",
		   "cstring", "filename",
		   NULL);

  xa_api_reg_fnct ("gtk_file_selection_get_filename", gtk_file_selection_get_filename, "cstring",
		   "pointer", "filesel",
		   NULL);

  xa_api_reg_fnct ("gtk_file_selection_complete", gtk_file_selection_complete, "void",
		   "pointer", "filesel",
		   "cstring", "pattern",
		   NULL);

  xa_api_reg_fnct ("gtk_file_selection_show_fileop_buttons", gtk_file_selection_show_fileop_buttons, "void",
		   "pointer", "filesel",
		   NULL);

  xa_api_reg_fnct ("gtk_file_selection_hide_fileop_buttons", gtk_file_selection_hide_fileop_buttons, "void",
		   "pointer", "filesel",
		   NULL);


  /* GtkFixed (fnct-complete)
   */

  xa_api_reg_native_class ("GtkFixed", NULL);

  xa_api_reg_fnct ("gtk_fixed_new", gtk_fixed_new, "pointer", NULL);

  xa_api_reg_fnct ("gtk_fixed_put", gtk_fixed_put, "void",
		   "pointer", "fixed",
		   "pointer", "widget",
		   "ushort", "x",
		   "ushort", "y",
		   NULL);

  xa_api_reg_fnct ("gtk_fixed_move", gtk_fixed_move, "void",
		   "pointer", "fixed",
		   "pointer", "widget",
		   "ushort", "x",
		   "ushort", "y",
		   NULL);


  /* GtkFontSelection (fnct-complete)
   */

  xa_api_reg_native_class ("GtkFontSelection", NULL);

  xa_api_reg_fnct ("gtk_font_selection_new", gtk_font_selection_new, "pointer", NULL);

  xa_api_reg_fnct ("gtk_font_selection_get_font", gtk_font_selection_get_font, "pointer",
		   "pointer", "fontsel",
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_get_font_name", gtk_font_selection_get_font_name, "cstring",
		   "pointer", "fontsel",	       
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_set_font_name", gtk_font_selection_set_font_name, "bool",
		   "pointer", "fontsel",
		   "cstring", "fontname",
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_get_preview_text", gtk_font_selection_get_preview_text, "cstring",
		   "pointer", "fontsel",
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_set_preview_text", gtk_font_selection_set_preview_text, "void",
		   "pointer", "fontsel",
		   "cstring", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_set_filter", gtk_font_selection_set_filter, "void",
		   "pointer", "fontsel",
		   "uint", "filter_type",
		   "uint", "font_type",
		   "pointer", "foundries",
		   "pointer", "weights",
		   "pointer", "slants",
		   "pointer", "setwidths",
		   "pointer", "spacings",
		   "pointer", "charsets",
		   NULL);

  /* GtkFontSeletionDialog (fnct-complete)
   */

  xa_api_reg_native_class ("GtkFontSelectionDialog", NULL);

  xa_api_reg_fnct ("gtk_font_selection_dialog_new", gtk_font_selection_dialog_new, "pointer", 
		   "cstring", "title",
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_dialog_get_font", gtk_font_selection_dialog_get_font, "pointer",
		   "pointer", "fontsel",
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_dialog_get_font_name", gtk_font_selection_dialog_get_font_name, "cstring",
		   "pointer", "fontsel",	       
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_dialog_set_font_name", gtk_font_selection_dialog_set_font_name, "bool",
		   "pointer", "fontsel",
		   "cstring", "fontname",
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_dialog_get_preview_text", gtk_font_selection_dialog_get_preview_text, "cstring",
		   "pointer", "fontsel",
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_dialog_set_preview_text", gtk_font_selection_dialog_set_preview_text, "void",
		   "pointer", "fontsel",
		   "cstring", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_font_selection_dialog_set_filter", gtk_font_selection_dialog_set_filter, "void",
		   "pointer", "fontsel",
		   "uint", "filter_type",
		   "uint", "font_type",
		   "pointer", "foundries",
		   "pointer", "weights",
		   "pointer", "slants",
		   "pointer", "setwidths",
		   "pointer", "spacings",
		   "pointer", "charsets",
		   NULL);

  /* GtkFrame (fnct-complete)
   */

  xa_api_reg_native_class ("GtkFrame", NULL);

  xa_api_reg_fnct ("gtk_frame_new", gtk_frame_new, "pointer", 
		   "cstring", "label",
		   NULL);

  xa_api_reg_fnct ("gtk_frame_set_label", gtk_frame_set_label, "void", 
		   "pointer", "frame",
		   "cstring", "label",
		   NULL);

  xa_api_reg_fnct ("gtk_frame_set_label_align", gtk_frame_set_label_align, "void", 
		   "pointer", "frame",
		   "float", "xalign",
		   "float", "yalign",
		   NULL);

  xa_api_reg_fnct ("gtk_frame_set_shadow_type", gtk_frame_set_shadow_type, "void", 
		   "pointer", "frame",
		   "uint", "type",
		   NULL);

  /* GtkWindow
   */

  xa_api_reg_fnct ("gtk_window_new", gtk_window_new, "pointer",
		   "uint", "type",
		   NULL);

  xa_api_reg_fnct ("gtk_window_set_title", gtk_window_set_title, "void",
		   "pointer", "window",
		   "cstring", "title",
		   NULL);

  /* GtkHandleBox
   */

  xa_api_reg_fnct ("gtk_handle_box_new", gtk_handle_box_new, "pointer",
		   NULL);

  /* GtkWidget
   */

  xa_api_reg_native_class ("GtkWidget", 
			   "pointer", "window", FIELD_POS(widget, window),
			   NULL);

  xa_api_reg_fnct ("gtk_widget_destroy", gtk_widget_destroy, "void",
		   "pointer", "widget",
		   NULL);

  xa_api_reg_fnct ("gtk_widget_show", gtk_widget_show, "void",
		   "pointer", "window",
		   NULL);

  xa_api_reg_fnct ("gtk_widget_show_all", gtk_widget_show_all, "void",
		   "pointer", "window",
		   NULL);

  xa_api_reg_fnct ("gtk_widget_realize", gtk_widget_realize, "void",
		   "pointer", "widget",
		   NULL);


  xa_api_reg_fnct ("gtk_widget_set_usize", gtk_widget_set_usize, "void",
		   "pointer", "widget",
		   "uint", "width",
		   "uint", "height",
		   NULL);

  xa_api_reg_fnct ("gtk_widget_set_uposition", gtk_widget_set_uposition, "void",
		   "pointer", "widget",
		   "uint", "x",
		   "uint", "y",
		   NULL);

  /* GtkSignal
   */

  xa_api_reg_fnct ("gtk_signal_connect", gtk_signal_connect, "uint",
		   "pointer", "object",
		   "cstring", "name",
		   "pointer", "fnct",
		   "pointer", "data",
		   NULL);      

  /* GtkMenuBar
   */

  xa_api_reg_fnct ("gtk_menu_bar_new", gtk_menu_bar_new, "pointer",
		   NULL);

  xa_api_reg_fnct ("gtk_menu_bar_append", gtk_menu_bar_append, "void",
		   "pointer", "menu_bar",
		   "pointer", "child",
		   NULL);

  /* GtkMenu
   */

  xa_api_reg_fnct ("gtk_menu_new", gtk_menu_new, "pointer",
		   NULL);

  xa_api_reg_fnct ("gtk_menu_append", gtk_menu_append, "void",
		   "pointer", "menu",
		   "pointer", "child",
		   NULL);



  /* GtkToolbar
   */

  xa_api_reg_native_class ("GtkToolbar", NULL);

  xa_api_reg_const_uint ("GTK_TOOLBAR_ICONS", GTK_TOOLBAR_ICONS);
  xa_api_reg_const_uint ("GTK_TOOLBAR_TEXT", GTK_TOOLBAR_TEXT);
  xa_api_reg_const_uint ("GTK_TOOLBAR_BOTH", GTK_TOOLBAR_BOTH);

  xa_api_reg_const_uint ("GTK_TOOLBAR_CHILD_SPACE", GTK_TOOLBAR_CHILD_SPACE);
  xa_api_reg_const_uint ("GTK_TOOLBAR_CHILD_BUTTON", GTK_TOOLBAR_CHILD_BUTTON);
  xa_api_reg_const_uint ("GTK_TOOLBAR_CHILD_TOGGLEBUTTON", GTK_TOOLBAR_CHILD_TOGGLEBUTTON);
  xa_api_reg_const_uint ("GTK_TOOLBAR_CHILD_RADIOBUTTON", GTK_TOOLBAR_CHILD_RADIOBUTTON);
  xa_api_reg_const_uint ("GTK_TOOLBAR_CHILD_WIDGET", GTK_TOOLBAR_CHILD_WIDGET);

  xa_api_reg_fnct ("gtk_toolbar_new", gtk_toolbar_new, "pointer",
		   "uint", "orientation",
		   "uint", "style",
		   NULL);

  xa_api_reg_fnct ("gtk_toolbar_append_space", gtk_toolbar_append_space, "void",
		   "pointer", "toolbar",
		   NULL);

  xa_api_reg_fnct ("gtk_toolbar_append_widget", gtk_toolbar_append_widget, "void",
		   "pointer", "toolbar",
		   "pointer", "widget",
		   "cstring", "tooltip_text",
		   "cstring", "tooltip_private_text",
		   NULL);

  xa_api_reg_fnct ("gtk_toolbar_append_item", gtk_toolbar_append_item, "pointer",
		   "pointer", "toolbar",
		   "cstring", "text",
		   "cstring", "tooltip_text",
		   "cstring", "tooltip_private_text",
		   "pointer", "icon",
		   "pointer", "callback",
		   "pointer", "user_data",
		   NULL);

  xa_api_reg_fnct ("gtk_toolbar_append_element", gtk_toolbar_append_element, "pointer",
		   "pointer", "toolbar",
		   "uint", "type",
		   "pointer", "widget",
		   "cstring", "text",
		   "cstring", "tooltip_text",
		   "cstring", "tooltip_private_text",
		   "pointer", "icon",
		   "pointer", "callback",
		   "pointer", "user_data",
		   NULL);

  /* GtkNotebook
   */

  xa_api_reg_fnct ("gtk_notebook_new", gtk_notebook_new, "pointer", NULL);
  
  xa_api_reg_fnct ("gtk_notebook_append_page", gtk_notebook_append_page, "void",
		   "pointer", "notebook",
		   "pointer", "child",
		   "pointer", "tap_label",
		   NULL);

  /* GtkTable
   */

  xa_api_reg_native_class ("GtkTable", NULL);

  xa_api_reg_fnct ("gtk_table_new", gtk_table_new, "pointer", 
		   "uint", "rows",
		   "uint", "columns",
		   "bool", "homogeneous",
		   NULL);

  xa_api_reg_fnct ("gtk_table_set_row_spacing", gtk_table_set_row_spacing, "pointer", 
		   "pointer", "table",
		   "uint", "row",
		   "uint", "spacing",
		   NULL);

  xa_api_reg_fnct ("gtk_table_set_col_spacing", gtk_table_set_col_spacing, "pointer", 
		   "pointer", "table",
		   "uint", "col",
		   "uint", "spacing",
		   NULL);

  xa_api_reg_fnct ("gtk_table_attach", gtk_table_attach, "pointer", 
		   "pointer", "table",
		   "pointer", "child",
		   "uint", "left_attach",
		   "uint", "right_attach",
		   "uint", "top_attach",
		   "uint", "bottom_attach",
		   "uint", "xoptions",
		   "uint", "yoptions",
		   "uint", "xpadding",
		   "uint", "ypadding",
		   NULL);  


  xa_api_reg_fnct ("gtk_label_new", gtk_label_new, "pointer", 
		   "cstring", "label",
		   NULL);

  /* GtkText
   */

  xa_api_reg_native_class ("GtkText", 
			   "pointer", "hadj", FIELD_POS(text, hadj),
			   "pointer", "vadj", FIELD_POS(text, vadj),
			   NULL);
 
  xa_api_reg_fnct ("gtk_text_new", gtk_text_new, "pointer", 
		   "pointer", "hadj",
		   "pointer", "vadj",
		   NULL);

  xa_api_reg_fnct ("gtk_text_set_editable", gtk_text_set_editable, "void",
		   "pointer", "text",
		   "bool", "editable",
		   NULL);

  xa_api_reg_fnct ("gtk_text_get_point", gtk_text_get_point, "uint", 
		   "pointer", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_text_set_point", gtk_text_set_point, "void", 
		   "pointer", "text",
		   "uint", "index",
		   NULL);

  xa_api_reg_fnct ("gtk_text_forward_delete", gtk_text_forward_delete, "void",
		   "pointer", "text",
		   "uint", "count",
		   NULL);

  xa_api_reg_fnct ("gtk_text_backward_delete", gtk_text_backward_delete, "void",
		   "pointer", "text",
		   "uint", "count",
		   NULL);

  xa_api_reg_fnct ("gtk_text_insert", gtk_text_insert, "void",
		   "pointer", "text",
		   "pointer", "font",
		   "pointer", "fore",
		   "pointer", "back",
		   "cstring", "chars",
		   "uint", "length",
		   NULL);

  xa_api_reg_fnct ("gtk_text_freeze", gtk_text_freeze, "void",
		   "pointer", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_text_thaw", gtk_text_thaw, "void",
		   "pointer", "text",
		   NULL);

  xa_api_reg_fnct ("gtk_text_get_length", gtk_text_get_length, "uint",
		   "pointer", "text",
		   NULL);


  /* GtkVBox
   */
  
  xa_api_reg_fnct ("gtk_vbox_new", gtk_vbox_new, "pointer",
		   "bool", "homogeneous",
		   "bool", "spacing",
		   NULL);
  
  /* GtkHBox
   */
  
  xa_api_reg_fnct ("gtk_hbox_new", gtk_hbox_new, "pointer",
		   "bool", "homogeneous",
		   "bool", "spacing",
		   NULL);

  /* GtkVScrollbar
   */

  xa_api_reg_fnct ("gtk_vscrollbar_new", gtk_vscrollbar_new, "pointer",
		   "pointer", "adjustment",
		   NULL);

  /* GtkHScrollbar
   */

  xa_api_reg_fnct ("gtk_hscrollbar_new", gtk_hscrollbar_new, "pointer",
		   "pointer", "adjustment",
		   NULL);  

  /* GtkStatusbar
   */
  
  xa_api_reg_fnct ("gtk_statusbar_new", gtk_statusbar_new, "pointer",
		   NULL);


  /* GtkTree
   */

  xa_api_reg_native_class ("GtkTree", NULL);

  xa_api_reg_fnct ("gtk_tree_new", gtk_tree_new, "pointer",
		   NULL);

  xa_api_reg_fnct ("gtk_tree_append", gtk_tree_append, "void",
		   "pointer", "tree",
		   "pointer", "tree_item",
		   NULL);

  xa_api_reg_fnct ("gtk_tree_prepend", gtk_tree_prepend, "void",
		   "pointer", "tree",
		   "pointer", "tree_item",
		   NULL);

  xa_api_reg_fnct ("gtk_tree_insert", gtk_tree_insert, "void",
		   "pointer", "tree",
		   "pointer", "tree_item",
		   "uint", "position",
		   NULL);

  /* GtkTreeItem
   */

  xa_api_reg_native_class ("GtkTreeItem", NULL);

  xa_api_reg_fnct ("gtk_tree_item_new", gtk_tree_item_new, "pointer",
		   NULL);

  xa_api_reg_fnct ("gtk_tree_item_new_with_label", gtk_tree_item_new_with_label, "pointer",
		   "cstring", "label",
		   NULL);

  xa_api_reg_fnct ("gtk_tree_item_set_subtree", gtk_tree_item_set_subtree, "void",
		   "pointer", "tree_item",
		   "pointer", "subtree",
		   NULL);

  /* GtkMenuItem
   */

  xa_api_reg_fnct ("gtk_menu_item_new", gtk_menu_item_new, "pointer",
		   NULL);
  
  xa_api_reg_fnct ("gtk_menu_item_new_with_label", gtk_menu_item_new_with_label, "pointer",
		   "cstring", "label",
		   NULL);
  
  xa_api_reg_fnct ("gtk_menu_item_set_submenu", gtk_menu_item_set_submenu, "pointer",
		   "pointer", "menu_item",
		   "pointer", "submenu",
		   NULL);
  

  /* GtkPixmap
   */

  xa_api_reg_native_class ("GtkPixmap", NULL);

  xa_api_reg_fnct ("gtk_pixmap_new", gtk_pixmap_new, "pointer",
		   "pointer", "pixmap",
		   "pointer", "mask",
		   NULL);

  /* GdkPixmap
   */

  xa_api_reg_native_class ("GdkPixmap", NULL);
 
  xa_api_reg_fnct ("gdk_pixmap_new", gdk_pixmap_new, "pointer",
		   "pointer", "window",
		   "uint", "width",
		   "uint", "height",
		   "uint", "depth",
		   NULL);

  xa_api_reg_fnct ("gdk_pixmap_create_from_xpm", gdk_pixmap_create_from_xpm, "pointer",
		   "pointer", "window",
		   "pointer", "mask",
		   "pointer", "transparent_color",
		   "cstring", "filename",
		   NULL);






  /* GtkTable
   */

  xa_api_reg_native_class ("GtkTable", NULL);  


  /* GdkBitmap
   */

  xa_api_reg_native_class ("GdkBitmap", NULL);
  
  xa_api_reg_class ("GdkColor",
		    "uint", "pixel",
		    "ushort", "red",
		    "ushort", "green",
		    "ushort", "blue",
		    NULL);


  /* LibGlade
   */

  xa_api_reg_native_class ("GladeXML", NULL);

  xa_api_reg_fnct ("glade_init", glade_init, "void",
		   NULL);

  xa_api_reg_fnct ("glade_xml_new", glade_xml_new, "pointer",
		   "cstring", "fname",
		   "cstring", "root",
		   NULL);

  xa_api_reg_fnct ("glade_xml_get_widget", glade_xml_get_widget, "pointer",
		   "pointer", "self",
		   "cstring", "name",
		   NULL);

  xa_api_reg_fnct ("glade_xml_signal_connect", glade_xml_signal_connect, "void",
		   "pointer", "self",
		   "cstring", "handlername",
		   "pointer", "func",
		   NULL);
}

xvoid
xa_gtk_exit ()
{
}
 

