/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlbuiltin.h>
#include <xlclass.h>
#include <xlmain.h>
#include <xlmeth.h>

#include <xapi/xaapi.h>

xvoid
xa_io_init ()
{
  xa_api_reg_fnct ("io_write", printf, "void",
		   "cstring", "format",
		   "...", 
		   NULL);

  xa_api_reg_fnct ("io_strwrite", sprintf, "void",
		   "cstring", "str",
		   "cstring", "format",
		   "...",
		   NULL);

  xa_api_reg_fnct ("io_read", scanf, "void",
		   "cstring", "format",
		   "...",
		   NULL);

  xa_api_reg_fnct ("io_file_open", fopen, "pointer",
		   "cstring", "filename",
		   "cstring", "flags",
		   NULL);
  
  xa_api_reg_fnct ("io_file_close", fclose, "void",
		   "pointer", "fileid",
		   NULL);

  xa_api_reg_fnct ("io_file_read", fread, "uint",
		   "cstring", "str",
		   "uint", "size",
		   "uint", "count",
		   "pointer", "fileid",
		   NULL);

  xa_api_reg_fnct ("io_file_write", fwrite, "uint",
		   "cstring", "str",
		   "uint", "size",
		   "uint", "count",
		   "pointer", "fileid",
		   NULL);
}

xvoid
xa_io_exit ()
{
}
 

