/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlbuiltin.h>
#include <xlclass.h>
#include <xlmain.h>
#include <xlmeth.h>

#include <xapi/xaapi.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <errno.h>

xptr
xa_net_socket ()
{
  return (xptr) socket (AF_INET, SOCK_STREAM, 0);
}

xvoid
xa_net_close (xuint socket)
{
  close (socket);
}

xvoid
xa_net_bind (xuint socket, xuint port)
{
  struct sockaddr_in  sin;

  memset (&sin, 0, sizeof (sin));

  sin.sin_family = AF_INET;
  sin.sin_port = htons (port);
  sin.sin_addr.s_addr = htonl (INADDR_ANY);
  
  bind (socket, (struct sockaddr*) &sin, sizeof (sin));
}

xuint
xa_net_listen (xuint socket, xuint backlog)
{
  return listen (socket, backlog);
}

xptr
xa_net_accept (xuint socket)
{
  struct sockaddr sa;
  xuint           len;

  return (xptr) accept (socket, &sa, &len);
}

xvoid
xa_net_send (xuint socket, xstr data)
{
  send (socket, data, strlen(data), 0);
}

xstr
xa_net_recvln (xuint socket)
{
  XString*	l_text;
  xuchar        c;
  xuint         i;
  int           ret;

  l_text = x_string_new ();

  i = 0;

  ret = recv (socket, &c, 1, 0);
  while (c != '\r' && c != '\n')
    {
      x_string_add_char (l_text, c);
      recv (socket, &c, 1, 0);
    }
  /* Eating '\n'
   */
  recv (socket, &c, 1, 0);
 
  return l_text->data;
}

xvoid
xa_net_init ()
{
  xa_api_reg_const_uint ("EPROTONOSUPPORT", EPROTONOSUPPORT);
  xa_api_reg_const_uint ("EMFILE", EMFILE);
  xa_api_reg_const_uint ("ENFILE", ENFILE);
  xa_api_reg_const_uint ("EACCES", EACCES);
  xa_api_reg_const_uint ("ENOBUFS", ENOBUFS);

  xa_api_reg_const_uint ("EBADF", EBADF);
  xa_api_reg_const_uint ("ENOTSOCK", ENOTSOCK);
  xa_api_reg_const_uint ("EOPNOTSUPP", EOPNOTSUPP);
  xa_api_reg_const_uint ("EWOULDBLOCK", EWOULDBLOCK);

  xa_api_reg_fnct ("net_socket", xa_net_socket, "pointer", NULL);  
  xa_api_reg_fnct ("net_bind", xa_net_bind, "void", 
		   "pointer", "socket",
		   "uint", "port",
		   NULL);  

  xa_api_reg_fnct ("net_close", xa_net_close, "pointer", 
		   "pointer", "socket",
		   NULL); 

  xa_api_reg_fnct ("net_listen", xa_net_listen, "uint", 
		   "pointer", "socket",
		   "uint", "backlog",
		   NULL); 

  xa_api_reg_fnct ("net_accept", xa_net_accept, "pointer", 
		   "pointer", "socket",
		   NULL); 

  xa_api_reg_fnct ("net_send", xa_net_send, "void", 
		   "pointer", "socket",
		   "cstring", "data",
		   NULL); 

  xa_api_reg_fnct ("net_recvln", xa_net_recvln, "cstring", 
		   "pointer", "socket",
		   NULL); 
}

xvoid
xa_net_exit ()
{
}
 



