/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlbuiltin.h>
#include <xlclass.h>
#include <xlmain.h>
#include <xlmeth.h>

#include <xapi/xaapi.h>

#include <sys/types.h>
#include <regex.h>

xvoid
xa_regex_init ()
{
  regex_t    regex;
  regmatch_t regmatch;
  xuint      status;

  xa_api_reg_const_uint ("REG_EXTENDED", REG_EXTENDED);
  xa_api_reg_const_uint ("REG_ICASE", REG_ICASE);
  xa_api_reg_const_uint ("REG_NOSUB", REG_NOSUB);
  xa_api_reg_const_uint ("REG_NEWLINE", REG_NEWLINE);

  xa_api_reg_class ("RegEx",
		    "uint", "re_magic", 
		    "uint", "re_nsub", 
		    "cstring", "re_endp", 
		    "pointer", "re_g",
                    "uint", "_a",
                    "uint", "_b",
		    "uint", "_c",
		    "uint", "_d",
		    NULL);

  xa_api_reg_class ("RegMatch",
		    "uint", "rm_so",
		    "uint", "rm_eo",
		    NULL);

  xa_api_reg_fnct ("regcomp", regcomp, "uint",
		   "pointer", "reg",
		   "cstring", "pattern",
		   "uint", "flags",
		   NULL);

  xa_api_reg_fnct ("regexec", regexec, "uint",
		   "pointer", "reg",
		   "cstring", "text",
		   "uint", "size",
		   "pointer", "regmatch",
		   "uint", "pos",
		   NULL);
}

xvoid
xa_regex_exit ()
{
}
 

