/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlbuiltin.h>
#include <xlclass.h>
#include <xlmain.h>
#include <xlmeth.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>

#include <xapi/xaapi.h>

xstr
xgetcwd ()
{
  return (xstr) getcwd (NULL, 0);
}

xvoid
xa_sys_init ()
{
  struct dirent   obj_dirent;

  xa_api_reg_fnct ("sys_exit", exit, "void",
		   "uint", "code",
		   NULL);
  
  xa_api_reg_fnct ("sys_exec", system, "void",
		   "cstring", "cmdname",
		   NULL);

  /* Directory 
   */

  xa_api_reg_fnct ("sys_getcwd", xgetcwd, "cstring",
		   NULL);

  xa_api_reg_fnct ("sys_chdir", chdir, "int",
		   "cstring", "directory",
		   NULL);

  xa_api_reg_fnct ("sys_mkdir", mkdir, "int",
		   "cstring", "directory",
		   "uint", "mode",
		   NULL);

  xa_api_reg_fnct ("sys_rmdir", rmdir, "int",
		   "cstring", "directory",
		   NULL);

  xa_api_reg_native_class ("dirent",
			   "pointer", "d_name", FIELD_POS(obj_dirent, d_name),
			   NULL);

  xa_api_reg_fnct ("sys_opendir", opendir, "pointer",
		   "cstring", "directory",
		   NULL);

  xa_api_reg_fnct ("sys_readdir", readdir, "pointer",
		   "pointer", "dir_stream",
		   NULL);

  xa_api_reg_fnct ("sys_closedir", closedir, "void",
		   "pointer", "dir_stream",
		   NULL);
}

xvoid
xa_sys_exit ()
{
}
 

