/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlbuiltin.h>
#include <xlclass.h>
#include <xlmain.h>
#include <xlmeth.h>

#include <xapi/xaapi.h>
#include <parser.h>

xvoid
xa_xml_init ()
{
  xmlDoc  xmldoc;
  xmlNode xmlnode;

  xa_api_reg_native_class ("xmlDocPtr",
			   "pointer", "children", FIELD_POS(xmldoc, root),
			   NULL);

  xa_api_reg_native_class ("xmlNodePtr", 
			   "cstring", "name", FIELD_POS(xmlnode, name),
			   "pointer", "children", FIELD_POS(xmlnode, childs),
			   "pointer", "last", FIELD_POS(xmlnode, last),
			   "pointer", "parent", FIELD_POS(xmlnode, parent),
			   "pointer", "next", FIELD_POS(xmlnode, next),
			   "pointer", "prev", FIELD_POS(xmlnode, prev),
			   "pointer", "doc", FIELD_POS(xmlnode, doc),
			   NULL);

  xa_api_reg_fnct ("xmlParseFile", xmlParseFile, "pointer",
		   "cstring", "filename",
		   NULL);

  xa_api_reg_fnct ("xmlDocGetRootElement", xmlDocGetRootElement, "pointer",
		   "pointer", "doc",
		   NULL);

  xa_api_reg_fnct ("xmlNewDoc", xmlNewDoc, "pointer",
		   "cstring", "version",
		   NULL);

  xa_api_reg_fnct ("xmlNewDocNode", xmlNewDocNode, "pointer",
		   "pointer", "doc",
		   "pointer", "ns",
		   "cstring", "name",
		   "cstring", "content",
		   NULL);

  xa_api_reg_fnct ("xmlNewChild", xmlNewChild, "pointer",
		   "pointer", "node",
		   "pointer", "ns",
		   "cstring", "name",
		   "cstring", "content",
		   NULL);

  xa_api_reg_fnct ("xmlSetProp", xmlSetProp, "uint",
		   "pointer", "node",
		   "cstring", "name",
		   "cstring", "value",
		   NULL);

  xa_api_reg_fnct ("xmlGetProp", xmlGetProp, "cstring",
		   "pointer", "node",
		   "cstring", "name",
		   NULL);

  xa_api_reg_fnct ("xmlSaveFile", xmlSaveFile, "void",
		   "cstring", "filename",
		   "pointer", "doc",
		   NULL);
}

xvoid
xa_xml_exit ()
{
}
 

