/* X/lang - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://xlang.sourceforge.net
 */


%{

#include <stdio.h>
#include <stdlib.h>

#include <xltype.h>
#include <xlexpr.h>

#include <xllang.h>
#include <langbasic_yacc.h>

xchar string_buf[10000];
xchar *string_buf_ptr;

%}

DIGIT		[0-9]
IDENTIFIER      [a-zA-Z_][a-zA-Z0-9_]*

%x string

%%

"'"[^\n]*[\n]               { g_lang_line++; }
[Ii][Ff]                    { return IF; }
[Ee][Ll][Ss][Ee]            { return ELSE; }
[Cc][Ll][Aa][Ss][Ss]        { return CLASS; }
[Vv][Oo][Ii][Dd]            { return VOID; }
[Cc][Hh][Aa][Rr]            { return CHAR; }
[Uu][Cc][Hh][Aa][Rr]        { return UCHAR; }
[Ee][Nn][Dd]                { return END; }
[Ss][Uu][Bb]                { return SUB; }
[Tt][Hh][Ee][Nn]            { return THEN; }
[Nn][Uu][Ll][Ll]            { return V_NULL; }
[Ff][Uu][Nn][Cc][Tt][Ii][Oo][Nn]  { return FUNCTION; }
short                { return SHORT; }
ushort               { return USHORT; }
int                  { return INT; }
[Uu][Ii][Nn][Tt][Ee][Gg][Ee][Rr]   { return UINT; }
[Ss][Ii][Nn][Gg][Ll][Ee]    { return FLOAT; }
double                      { return DOUBLE; }
[Ss][Tt][Rr][Ii][Nn][Gg]    { return STRING; }
pointer                     { return POINTER; }
[Hh][Aa][Nn][Dd][Ll][Ee]    { return POINTER; }
bool                 { return BOOL; }
return               { return RETURN; }
while                { return WHILE; }
dynamic              { return DYNAMIC; }
static               { return STATIC; }
true                 { return V_TRUE; }
false                { return V_FALSE; }
[Aa][Ss]             { return AS; }
{IDENTIFIER}         { 
                       strcpy (basic_lval.identifier, basic_text);
                       return IDENTIFIER; 
                     }
{DIGIT}+             {
                       basic_lval.val_int = atoi (basic_text);
                       return V_INT;
                     }
{DIGIT}+"."{DIGIT}*  {
                       basic_lval.val_float = atof (basic_text);
                       return V_FLOAT;
                     }
\"                   {
                        string_buf[0] = '\0';
                        string_buf_ptr = string_buf;
                        BEGIN(string);
                     }
<string>\\n          *string_buf_ptr++ = '\n';
<string>\\t          *string_buf_ptr++ = '\t';
<string>\\r          *string_buf_ptr++ = '\r';
<string>\\\"         *string_buf_ptr++ = '\"';
<string>\\\\         *string_buf_ptr++ = '\\';
<string>[^\"]    {
                        *string_buf_ptr++ = basic_text[0];
                     }
<string>\"           {
                        *string_buf_ptr = '\0';
                        strcpy (basic_lval.val_string, string_buf);
                        BEGIN(INITIAL);

                        return V_STRING;
                     }
[ \t\r]              /* White spaces */
[\n]                 { g_lang_line++; }

.		     { return basic_text[0]; }






