/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_BUILTIN_H_
#define __XL_BUILTIN_H_

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xlexpr.h>
#include <xlclass.h>

XLClass* g_xl_builtin_current_class;

xvoid
xl_builtin_init ();

xvoid
xl_builtin_exit ();


/* Declarators
 */

xvoid
xl_builtin_fnct (XLExpr* p_expr);

xvoid
xl_builtin_dlfnct (XLExpr* p_expr);

xvoid
xl_builtin_local (XLExpr* p_expr);

xvoid
xl_builtin_global (XLExpr* p_expr);

xvoid
xl_builtin_const (XLExpr* p_expr);

xvoid
xl_builtin_class (XLExpr* p_expr);

xvoid
xl_builtin_native_class (XLExpr* p_expr);

xvoid
xl_builtin_native_field (XLExpr* p_expr);

xvoid
xl_builtin_native_method (XLExpr* p_expr);

xvoid
xl_builtin_prop (XLExpr* p_expr);

xvoid
xl_builtin_meth (XLExpr* p_expr);

xvoid
xl_builtin_meth_static (XLExpr* p_expr);


/* Class & Objects
 */

xvoid
xl_builtin_new (XLExpr* p_expr);

xvoid
xl_builtin_access (XLExpr* p_expr);

xvoid
xl_builtin_invoke (XLExpr* p_expr);


/* Assignement
 */

xvoid
xl_builtin_assign  (XLExpr* p_expr);

xvoid
xl_builtin_cast  (XLExpr* p_expr);


/* Binary
 */

xvoid
xl_builtin_binary_or (XLExpr* p_expr);

xvoid
xl_builtin_binary_and (XLExpr* p_expr);


/* Logic
 */

xvoid
xl_builtin_logic_or (XLExpr* p_expr);

xvoid
xl_builtin_logic_and (XLExpr* p_expr);

/* Mathematics
 */

xvoid
xl_builtin_add (XLExpr* p_expr);

xvoid
xl_builtin_sub (XLExpr* p_expr);

xvoid
xl_builtin_mul (XLExpr* p_expr);

xvoid
xl_builtin_div (XLExpr* p_expr);

xvoid
xl_builtin_inc (XLExpr* p_expr);

xvoid
xl_builtin_dec (XLExpr* p_expr);


/* Flow control
 */

xvoid
xl_builtin_block (XLExpr* p_expr);

xvoid
xl_builtin_if (XLExpr* p_expr);

xvoid
xl_builtin_while (XLExpr* p_expr);

xvoid
xl_builtin_for (XLExpr* p_expr);

xvoid
xl_builtin_return (XLExpr* p_expr);


/* Comparaisons
 */

xvoid
xl_builtin_cmp_l (XLExpr* p_expr);

xvoid
xl_builtin_cmp_g (XLExpr* p_expr);

xvoid
xl_builtin_cmp_le (XLExpr* p_expr);

xvoid
xl_builtin_cmp_ge (XLExpr* p_expr);

xvoid
xl_builtin_cmp_ne (XLExpr* p_expr);

xvoid
xl_builtin_cmp_e (XLExpr* p_expr);


/* Language control
 */

xvoid
xl_builtin_import (XLExpr* p_expr);

xvoid
xl_builtin_ifdef (XLExpr* p_expr);

xvoid
xl_builtin_array (XLExpr* p_expr);

xvoid
xl_builtin_array_getsize (XLExpr* p_expr);

xvoid
xl_builtin_array_resize (XLExpr* p_expr);

/* Low-level functions
 */

xvoid
xl_builtin_addr_of (XLExpr* p_expr);

xvoid
xl_builtin_set_raw (XLExpr* p_expr);

xvoid
xl_builtin_str_setsize (XLExpr* p_expr);

#endif
