/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_CLASS_H_
#define __XL_CLASS_H_

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xlist.h>

#define XL_CLASS(obj) ((XLClass*) obj)

typedef enum {
  XL_CLASS_DEFAULT,
  XL_CLASS_BINDING_PTR,
  XL_CLASS_BINDING_STRUCT
} XLClassType;

typedef struct _XLData XLData;
typedef struct _XLField XLField;
typedef struct _XLMeth XLMeth;
typedef struct _XLClass XLClass;
struct _XLClass
{
  XObject   parent;

  XString*  name;
  XLClass*  parent_class;

  XList*    list_fields;
  XList*    list_methods;

  xuint        size;
  XLClassType type;
};

XLClass*
xl_class_new (XString* p_name, XLClassType p_type, xuint p_size);

xvoid
xl_class_destroy (XObject* self);

xvoid
xl_class_init_data (XLClass* self, XLData* p_data);

xuint
xl_class_get_size (XLClass* self);

xvoid
xl_class_add_field (XLClass* self, XLField* p_field);

xvoid
xl_class_add_field_offset (XLClass* self, XLField* p_field, xuint p_offset);

XLField*
xl_class_get_field (XLClass* self, XString* p_name);

xvoid
xl_class_add_method (XLClass* self, XLMeth* p_method);

XLMeth*
xl_class_get_method (XLClass* self, XString* p_name);

#endif
