/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_DATA_H_
#define __XL_DATA_H_

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xltype.h>

#define XL_DATA(obj) ((XLData*) obj)

struct _XLData
{
  XObject parent;
  
  XLType* type;
  xbool   ref;
  xptr	  raw;
};

XLData*
xl_data_new (XLType* p_type, xptr p_ref);

xvoid
xl_data_destroy (XObject* self);

xvoid
xl_data_init_data (XLData* self);

xvoid
xl_data_set_type (XLData* self, XLType* p_type);

XString*
xl_data_get_string (XLData* self);

xvoid
xl_data_set_string (XLData* self, XString* p_value);

xptr
xl_data_get_raw (XLData* self);

xvoid
xl_data_assign (XLData* self, XLData* p_src);

XLData*
xl_data_copy (XLData* self);

XLData*
xl_data_addref_field (XLData* self, XLField* p_field);

XLData*
xl_data_convert (XLData* self, XLType* p_type);

XLData*
xl_data_get_index (XLData* self, xuint p_index);

xuint
xl_data_array_get_size (XLData* self);

xvoid
xl_data_array_set_size (XLData* self, xuint p_newsize);

XLData*
xl_data_get_field (XLData* self, XString* p_fieldname, xbool p_force);

xptr
xl_data_get_ptr (XLData* self);

xvoid
xl_data_set_raw (XLData* self, xptr p_raw);

#endif

