/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlmain.h>
#include <xllang.h>
#include <xlbuiltin.h>
#include <cmdline.h>

#include <xapi/xalang.h>
#include <xapi/xasys.h>
#include <xapi/xaio.h>
#include <xapi/xanet.h>

#include <xapi/xagtk.h>
#include <xapi/xaregex.h>
#include <xapi/xaxml.h>

#include <gtk/gtk.h>

#include <cmdline.h>
#include <langc_yacc.h>

#include <malloc.h>
#include <errno.h>

XLMain* g_xl_main_global = NULL;

xvoid
xl_main_init ()
{
  g_xl_main_global = xl_main_new ();
}

xvoid
xl_main_exit ()
{
  x_unref (g_xl_main_global);
}

XLMain*
xl_main_new ()
{
  XLMain *self;

  self = x_new (XLMain);
  x_object_init_object (X_OBJECT (self), xl_main_destroy);

  self->debugger = FALSE;
  self->list_global = x_list_new ();
  self->list_stack = x_list_new ();
  self->list_local = NULL;
  self->list_functions = x_list_new ();
  self->list_classes = x_list_new ();	
  
  return self;
}

xvoid
xl_main_destroy (XObject* self)
{
  x_unref (XL_MAIN (self)->list_global);
  x_unref (XL_MAIN (self)->list_stack);
  x_unref (XL_MAIN (self)->list_local);
  x_unref (XL_MAIN (self)->list_functions);
  x_unref (XL_MAIN (self)->list_classes);
  
  x_destroy (self);
}

xvoid
xl_main_add_fnct_builtin (XLMain* self, xstr p_name, XLFnctBuiltin p_builtin)
{
  XLFnct*	l_fnct;
  XString*	l_name;
  
  l_fnct = xl_fnct_new ();
  l_name = x_string_new ();

  x_string_set_str (l_name, p_name);
  xl_fnct_set_builtin (l_fnct, l_name, p_builtin);
  
  x_list_add (self->list_functions, X_OBJECT (l_fnct));

  x_unref (l_fnct);
  x_unref (l_name);
}

XLFnct*
xl_main_add_fnct_native (XLMain* self, xstr p_name, xptr p_native)
{
  XLFnct*	l_fnct;
  XString*	l_name;
  
  l_fnct = xl_fnct_new ();
  l_name = x_string_new ();

  x_string_set_str (l_name, p_name);
  xl_fnct_set_native (l_fnct, l_name, p_native);
  
  x_list_add (self->list_functions, X_OBJECT (l_fnct));

  x_unref (l_fnct);
  x_unref (l_name);

  return l_fnct;
}

XLFnct*
xl_main_add_fnct_expr (XLMain* self, xstr p_name, XLExpr* p_expr)
{
  XLFnct*	l_fnct;
  XString*	l_name;
  
  l_fnct = xl_fnct_new ();
  l_name = x_string_new ();

  x_string_set_str (l_name, p_name);
  xl_fnct_set_expr (l_fnct, l_name, p_expr);
  
  x_list_add (self->list_functions, X_OBJECT (l_fnct));

  x_unref (l_fnct);
  x_unref (l_name);

  return l_fnct;
}

XLFnct*
xl_main_get_fnct (XLMain* self, XString* p_name)
{
  XLFnct*	l_fnct;
  xuint		i, l_size;
	
  l_size = x_list_get_size (self->list_functions);
  
  for (i = 0; i < l_size; i++)
    {
      l_fnct = XL_FNCT (x_list_get (self->list_functions, i));
      if (x_string_cmp (p_name, l_fnct->name) == 0)
	return l_fnct;
       
      x_unref (l_fnct);
    }
  
  return NULL;
}

xvoid
xl_main_add_var (XLMain* self, XLVar* p_var, xbool p_global)
{
  if ((self->list_local) && !p_global)
    x_list_add (self->list_local, X_OBJECT (p_var));
  else
    x_list_add (self->list_global, X_OBJECT (p_var));
}

XLVar*
xl_main_get_var (XLMain* self, XString* p_name)
{
  XLVar*	l_var;
  xuint		i, l_size;
	
  if (self->list_local)
    {
      l_size = x_list_get_size (self->list_local);
      for (i = 0; i < l_size; i++)
	{
	  l_var = XL_VAR (x_list_get (self->list_local, i));
	  if (x_string_cmp (p_name, l_var->name) == 0)
	      return l_var;

	  x_unref (l_var);
	}
    }

  l_size = x_list_get_size (self->list_global);
  for (i = 0; i < l_size; i++)
    {
      l_var = XL_VAR (x_list_get (self->list_global, i));
      if (x_string_cmp (p_name, l_var->name) == 0)
	return l_var;
		
      x_unref (l_var);
    }
  
  return NULL;
}

xvoid
xl_main_add_class (XLMain* self, XLClass* p_class)
{
  x_list_add (self->list_classes, X_OBJECT (p_class));
}

XLClass*
xl_main_get_class (XLMain* self, XString* p_name)
{
  XLClass*	l_class;
  xuint		i, l_size;

  l_size = x_list_get_size (self->list_classes);
  for (i = 0; i < l_size; i++)
    {
      l_class = XL_CLASS (x_list_get (self->list_classes, i));
      if (x_string_cmp (p_name, l_class->name) == 0)
	return l_class;
 
      x_unref (l_class);
    }

  return NULL;
}

XList*
xl_main_fnct_enter (XLMain* self, XLFnct* p_fnct)
{
  XList* l_list;

  l_list = self->list_local;
  self->list_local = x_list_new ();

  x_list_add (self->list_stack, X_OBJECT (p_fnct));

  return l_list;
}

xvoid
xl_main_fnct_leave (XLMain* self, XList* p_list)
{
  xuint idx;

  idx = x_list_get_size (self->list_stack);
  x_list_remove (self->list_stack, idx - 1);

  x_unref (self->list_local);
  self->list_local = p_list;
}

xvoid
xl_main_print (XString* p_msg)
{
}

int
xl_main_main (int argc, char** argv)
{
  struct gengetopt_args_info args_info;
  XLExpr*      l_expr;
  XLFnct*      l_fnct;
  XString*     l_filename;
  XString*     l_name;
  XLLang*      l_lang;
  xuint         l_size;
  xuint         i;
  xuint         idx;
  xvoid        (*xmain) ();

  xl_main_init ();
  xl_builtin_init ();

  gtk_init_check (&argc, &argv);

  xa_lang_init ();
  xa_sys_init ();
  xa_io_init ();
  xa_net_init ();

  xa_gtk_init ();
  xa_regex_init ();
  xa_xml_init ();

  /* Choose the right language from the file name
   * .xc = c
   * .xb = basic
   * .xl = lisp
   */

  if (cmdline_parser (argc, argv, &args_info) != 0)
    exit (1);


  if (args_info.debug_flag)
    g_xl_main_global->debugger = TRUE;
  else
    g_xl_main_global->debugger = FALSE;

  if (args_info.inputs_num == 0)
    {
      printf ("ERROR: Type 'xlang --help' for help\n");
      exit (1);
    }

  l_lang = xl_lang_new (args_info.inputs[0]);
  if (!l_lang)
    {
      printf ("ERROR: Invalid filename extension\n");
      exit (-1);
    }

  l_filename = x_string_new ();
  x_string_set_str (l_filename, args_info.inputs[0]);

  l_expr = (*(l_lang->load)) (l_lang, l_filename);
  if (l_expr)
    {
      xl_expr_evaluate (l_expr);
      x_unref (l_expr);
      
      if (args_info.jit_flag)
	{
	  l_size = x_list_get_size (g_xl_main_global->list_functions); 
	  for (i = 0; i < l_size; i++)
	    {
	      l_fnct = XL_FNCT (x_list_get (g_xl_main_global->list_functions, i));
	      xl_fnct_compile (l_fnct);
	      x_unref (l_fnct);
	    }
	}

      l_name = x_string_new ();
      x_string_set_str (l_name, "main");
      l_fnct = xl_main_get_fnct (g_xl_main_global, l_name);
      x_unref (l_name);
      if (l_fnct)
	{
	  if (args_info.jit_flag)
	    {
	      xmain = (void (*)()) x_zone_get_ptr (l_fnct->native_code);
	      
	      printf ("Start the compiled program\n");
	      (*xmain) ();
	      printf ("End\n");
	    }
	  else
	    {
	      xl_fnct_call (l_fnct, NULL);
	    }
	  x_unref (l_fnct);
	}
      else
	{
	  printf ("Function 'main' not founded\n");
	}
    }
 
  x_unref (l_lang);
  x_unref (l_filename);

  xl_builtin_exit ();
  xl_main_exit ();
    
  return 0;
}
