/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_METH_H_
#define __XL_METH_H_

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xlfnct.h>

#define XL_METH(obj) ((XLMeth*) obj)

typedef enum {
  XL_METH_NORMAL,
  XL_METH_STATIC
} XLMethType;

struct _XLMeth
{
  XObject parent;
  
  XString* name;
  XString* fnctname;
  XLFnct* fnct;
  XLMethType type;
};

XLMeth*
xl_meth_new (XString* p_name, XString* p_fnctname, XLMethType p_type);

XLFnct*
xl_meth_get_fnct (XLMeth* self);

xvoid
xl_meth_destroy (XObject* self);

#endif
