/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_TYPE_H_
#define __XL_TYPE_H_

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xlclass.h>

#define XL_TYPE(obj) ((XLType*) obj)

typedef enum {
  XL_TYPE_TYPE_VOID,
  XL_TYPE_TYPE_S8,
  XL_TYPE_TYPE_U8,
  XL_TYPE_TYPE_S16,
  XL_TYPE_TYPE_U16,
  XL_TYPE_TYPE_S32,
  XL_TYPE_TYPE_U32,
  XL_TYPE_TYPE_S64,
  XL_TYPE_TYPE_U64,
  XL_TYPE_TYPE_F32,
  XL_TYPE_TYPE_F64,
  XL_TYPE_TYPE_BOOL,
  XL_TYPE_TYPE_POINTER,
  XL_TYPE_TYPE_STRING,
  XL_TYPE_TYPE_STATIC,
  XL_TYPE_TYPE_DYNAMIC,
  XL_TYPE_TYPE_MAPPING,
  XL_TYPE_TYPE_FNCT,
  XL_TYPE_TYPE_STRING_NATIVE
} XLTypeType;

typedef enum {
  XL_TYPE_ARRAY_TYPE_NONE,
  XL_TYPE_ARRAY_TYPE_FIXED,
  XL_TYPE_ARRAY_TYPE_DYNAMIC
} XLTypeArrayType;

typedef struct _XLType XLType;
struct _XLType
{
  XObject parent;
  
  XLTypeType	   type;
  XLTypeArrayType  array_type;
  xuint		   array_size;
  XString*         classname;
  XLClass*	   class;
};

XLType*
xl_type_new (XLTypeType p_type, XLTypeArrayType p_array_type, xuint p_array_size, XString* p_classname);

xvoid
xl_type_destroy (XObject* self);

xuint
xl_type_get_size (XLType* self);

XLClass*
xl_type_get_class (XLType* self);

xvoid
xl_type_init_data (XLType* self, XLData* p_data);

xbool
xl_type_validate (XLType* self, XLType* p_type);

#endif
























