/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlist.h>

XList*
x_list_new ()
{
  XList *self;

  self = x_new (XList);
  x_object_init_object (X_OBJECT (self), x_list_destroy);

  self->data = NULL;
  self->size = 0;

  return self;
}

xvoid
x_list_destroy (XObject* self)
{
  x_list_clear (X_LIST (self));

  x_destroy (X_LIST (self)->data);
  x_destroy (self);
}

xvoid
x_list_clear (XList* self)
{
  while (x_list_get_size (self))
    {
      x_list_remove (self, 0);
    }
}

xuint
x_list_get_size (XList* self)
{
  return self->size;
}

xvoid
x_list_resize (XList* self, xuint p_newsize)
{
  self->data = x_resize (self->data, p_newsize * sizeof (XObject*));
  self->size = p_newsize;
}

XObject*
x_list_get (XList* self, xuint p_index)
{
  if (p_index < self->size)
    return x_addref (XObject, self->data[p_index]);
  else
    return NULL;
}

xvoid
x_list_add (XList* self, XObject* p_item)
{
  self->size++;
  x_list_resize (self, self->size);
  self->data[self->size - 1] = x_addref (XObject, p_item);
}

xvoid
x_list_remove (XList* self, xuint p_index)
{
  self->size--;
  x_unref (self->data[p_index]);
  x_mem_copy (&(self->data[p_index + 1]), &(self->data[p_index]), (self->size - p_index) * sizeof (XObject*));
}












