/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xstring.h>

XString*
x_string_new ()
{
  XString* self;

  self = x_new (XString);
  self->data = NULL;
  x_object_init_object (X_OBJECT (self), (XObjectDestroy) x_string_destroy);

  x_string_clear (self);

  return self;
}

xvoid
x_string_destroy (XString* self)
{
  x_destroy (self->data);
  x_destroy (self);
}

xvoid
x_string_clear (XString* self)
{
  x_string_set_str (self, "");
}

xvoid
x_string_set (XString* self, XString* p_text)
{
  x_string_set_str (self, p_text->data);
}

xvoid
x_string_set_str (XString* self, xstr p_text)
{
  if (p_text)
    {
      self->data = (xstr) x_resize (self->data, strlen (p_text) + 1);
      strcpy (self->data, p_text);
    }
}

xvoid
x_string_add (XString* self, XString* p_text)
{
  x_string_add_str (self, p_text->data);
}

xvoid
x_string_add_str (XString* self, xstr p_text)
{
  self->data = (xstr) x_resize (self->data, strlen (self->data) + strlen (p_text) + 1);
  strcat (self->data, p_text);
}

xvoid
x_string_add_char (XString* self, xchar p_char)
{
  xuint	l_size;
  
  l_size = x_string_get_size (self);
  self->data = (xstr) x_resize (self->data, l_size + 2);
  self->data[l_size] = p_char;
  self->data[l_size + 1] = '\0';
}

xint
x_string_cmp (XString* self, XString* p_text)
{
  return x_string_cmp_str (self, p_text->data);
}

xint
x_string_cmp_str (XString* self, xstr p_text)
{
  return strcmp (self->data, p_text);
}

xint
x_string_ncmp (XString* self, XString* p_text, xuint p_pos, xuint p_size)
{
  return strncmp (self->data + p_pos, p_text->data, p_size);
}

xint
x_string_ncmp_str (XString* self, xstr p_text, xuint p_pos, xuint p_size)
{
  return strncmp (self->data + p_pos, p_text, p_size);
}

xuint
x_string_get_size (XString* self)
{
  if (self)
    return strlen (self->data);
  else 
    return 0;
}

xchar
x_string_get_char (XString* self, xuint p_index)
{
  return self->data[p_index];
}

xstr
x_string_get_str (XString* self)
{
  if (self)
    return self->data;
  else
    return NULL;
}

XString*
x_string_extract (XString* self, xuint p_index, xuint p_size)
{
  XString*	l_string;
  xuint		i;
  
  l_string = x_string_new ();
  for (i = 0; i < p_size; i++)
    x_string_add_char (l_string, x_string_get_char (self, p_index + i));
  
  return l_string;
}
