/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <xlbuiltin.h>
#include <xlclass.h>
#include <xlmain.h>
#include <xlmeth.h>
#include <xllang.h>

#include <xapi/xaapi.h>
#include <wnd/xwnd.h>

XLFnct* g_xa_wnd_event_handler = NULL;

XLExpr*
xa_wnd_mapping_create (xptr p_ptr)
{
  XLExpr* l_expr;
  XLType* l_type;
  XLData* l_data;
  XString* l_name;

  l_name = x_string_new ();
  x_string_set_str (l_name, "WndEvent");

  l_type = xl_type_new (XL_TYPE_TYPE_UNKNOWN, XL_TYPE_ARRAY_TYPE_NONE, 0, l_name);
  l_data = xl_data_new (l_type, NULL);
  x_access (xl_data_get_raw (l_data), 0, xptr) = p_ptr;
  
  l_expr = xl_expr_new ();
  xl_expr_set_data (l_expr, l_data);

  x_unref (l_name);
  x_unref (l_type);
  x_unref (l_data);

  return l_expr;
}

xvoid
xa_wnd_event_handler (XWndEvent* evt)
{
  XLExpr* l_expr;
  XLExpr* l_event;

  if (g_xa_wnd_event_handler)
    {
      l_expr = xl_expr_new_fnct (x_string_get_str (g_xa_wnd_event_handler->name));
      l_event = xa_wnd_mapping_create ((xptr) evt);
      xl_expr_add (l_expr, l_event);
      x_unref (l_event);
      
      xl_expr_evaluate (l_expr);
      
      x_unref (l_expr);
    }
}

xvoid
xa_wnd_event_register (XLExpr* p_expr)
{
  XLExpr*  l_expr;
  XLFnct*  l_fnct;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_fnct = xl_main_get_fnct (g_xl_main_global, l_expr->identifier);
  x_unref (l_expr);

  g_xa_wnd_event_handler = l_fnct;
}

xvoid
xa_wnd_init ()
{
#ifdef HAVE_GUI

  XWndEvent evt;

  x_wnd_event_register ((XWndEventCallback) xa_wnd_event_handler);
  xl_main_add_fnct_builtin (g_xl_main_global, "wnd_event_register", xa_wnd_event_register);

  xa_api_reg_const_uint ("WND_EVENT_UNKNOWN", XWND_EVENT_UNKNOWN);

  xa_api_reg_const_uint ("WND_EVENT_WINDOW_PAINT", XWND_EVENT_WINDOW_PAINT);
  xa_api_reg_const_uint ("WND_EVENT_WINDOW_MOVE", XWND_EVENT_WINDOW_MOVE);
  xa_api_reg_const_uint ("WND_EVENT_WINDOW_SIZE", XWND_EVENT_WINDOW_SIZE);
  xa_api_reg_const_uint ("WND_EVENT_WINDOW_CLOSE", XWND_EVENT_WINDOW_CLOSE);

  xa_api_reg_const_uint ("WND_EVENT_MOUSE_ENTER", XWND_EVENT_MOUSE_ENTER);
  xa_api_reg_const_uint ("WND_EVENT_MOUSE_LEAVE", XWND_EVENT_MOUSE_LEAVE);
  xa_api_reg_const_uint ("WND_EVENT_MOUSE_MOVE", XWND_EVENT_MOUSE_MOVE);
  xa_api_reg_const_uint ("WND_EVENT_MOUSE_DOWN", XWND_EVENT_MOUSE_DOWN);
  xa_api_reg_const_uint ("WND_EVENT_MOUSE_UP", XWND_EVENT_MOUSE_UP);

  xa_api_reg_const_uint ("WND_EVENT_KEY_DOWN", XWND_EVENT_KEY_DOWN);
  xa_api_reg_const_uint ("WND_EVENT_KEY_UP", XWND_EVENT_KEY_UP);

  /* Registering WND api
   */

  xa_api_reg_fnct ("wnd_main", x_wnd_main, "void", NULL);

  xa_api_reg_fnct ("wnd_window_init", x_wnd_window_init, "bool", NULL);

  xa_api_reg_fnct ("wnd_window_open", x_wnd_window_open, "int",
		   "string", "title",
		   "uint", "x",
		   "uint", "y",
		   "uint", "w",
		   "uint", "h",
		   "uint", "parent",
		   NULL);

  xa_api_reg_fnct ("wnd_window_set_pos", x_wnd_window_set_pos, "void",
		   "uint", "wnd",
		   "int", "x", 
		   "int", "y",
		   NULL);

  xa_api_reg_fnct ("wnd_window_set_size", x_wnd_window_set_size, "void",
		   "uint", "wnd",
		   "int", "w",
		   "int", "h",
		   NULL);

  xa_api_reg_fnct ("wnd_window_get_size_w", x_wnd_window_get_size_w, "uint",
		   "uint", "wnd",
		   NULL);

  xa_api_reg_fnct ("wnd_window_get_size_h", x_wnd_window_get_size_h, "uint",
		   "uint", "wnd",
		   NULL);

  xa_api_reg_fnct ("wnd_window_set_parent", x_wnd_window_set_parent, "void",
		   "uint", "wnd",
		   "uint", "parent",
		   NULL);

  xa_api_reg_fnct ("wnd_window_set_show", x_wnd_window_set_show, "void",
		   "uint", "wnd",
		   "bool", "is_show",
		   NULL);

  xa_api_reg_fnct ("wnd_window_redraw", x_wnd_window_redraw, "void",
		   "uint", "wnd",
		   NULL);

  xa_api_reg_fnct ("wnd_window_get_gc", x_wnd_window_get_gc, "uint",
		   "uint", "wnd",
		   NULL);

  xa_api_reg_fnct ("wnd_window_release_gc", x_wnd_window_release_gc, "void",
		   "uint", "wnd",
		   "uint", "gc",
		   NULL);

  xa_api_reg_fnct ("wnd_event_get", x_wnd_event_get, "uint", NULL);

  xa_api_reg_fnct ("wnd_gc_draw_line", x_wnd_gc_draw_line, "void",
		   "uint", "gc",
		   "int", "x1",
		   "int", "y1", 
		   "int", "x2",
		   "int", "y2",
		   NULL);

  xa_api_reg_fnct ("wnd_gc_set_fg_color", x_wnd_gc_set_fg_color, "void",
		   "uint", "gc",
		   "int", "r",
		   "int", "g", 
		   "int", "b",
		   NULL);

  xa_api_reg_fnct ("wnd_gc_draw_text", x_wnd_gc_draw_text, "void",
		   "uint", "gc",
		   "int", "x",
		   "int", "y", 
		   "string", "text",
		   NULL);

  xa_api_reg_fnct ("wnd_gc_draw_rectangle", x_wnd_gc_draw_rectangle, "void",
		   "uint", "gc",
		   "int", "x",
		   "int", "y", 
		   "int", "w",
		   "int", "h", 
		   NULL);

  xa_api_reg_fnct ("wnd_gc_get_text_width", x_wnd_gc_get_text_width, "int",
		   "uint", "gc",
		   "string", "text",
		   NULL);

  xa_api_reg_fnct ("wnd_gc_get_text_height", x_wnd_gc_get_text_height, "int",
		   "uint", "gc",
		   "string", "text",
		   NULL);

#endif	
}

xvoid
xa_wnd_exit ()
{
}
 



