/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>

#include <xldefs.h>
#include <xlfield.h>
#include <xlfnct.h>
#include <xltype.h>
#include <xlmain.h>
#include <xllang.h>
#include <xlcompiler.h>
#include <stdarg.h>

xptr (* xl_fnct_direct_void) ();
xptr (* xl_fnct_direct) (int x, ...);

xfloat (* xl_fnct_direct_void_float) ();
xfloat (* xl_fnct_direct_float) (int x, ...);

XLData* g_xl_fnct_return = NULL;
XLFnct* g_xl_fnct_current = NULL;
xbool   g_xl_fnct_halt = FALSE;

XLFnct*
xl_fnct_new ()
{
  XLFnct *self;
  
  self = x_new (XLFnct);
  x_object_init_object (X_OBJECT (self), xl_fnct_destroy);
  
  self->type = XL_FNCT_TYPE_NONE;
  self->expr = NULL;
  self->ret_type = NULL;
  self->name = x_string_new ();
  self->list_params = x_list_new ();
  self->opt_param = FALSE;
  self->native_code = x_zone_new ();

  return self;
}

xvoid
xl_fnct_destroy (XObject* self)
{
  x_unref (XL_FNCT (self)->expr);
  x_unref (XL_FNCT (self)->name);
  x_unref (XL_FNCT (self)->ret_type);
  x_unref (XL_FNCT (self)->list_params);
  x_unref (XL_FNCT (self)->native_code);
  
  x_destroy (self);
}

xvoid
xl_fnct_set_builtin (XLFnct* self, XString* p_name, XLFnctBuiltin p_builtin)
{
  self->type = XL_FNCT_TYPE_BUILTIN;
  self->builtin = p_builtin;

  x_unref (self->name);
  self->name = x_addref (XString, p_name);
}

xvoid
xl_fnct_set_native (XLFnct* self, XString* p_name, xptr p_native)
{
  self->type = XL_FNCT_TYPE_NATIVE;
  self->native = p_native;

  x_unref (self->name);
  self->name = x_addref (XString, p_name);
}

xvoid
xl_fnct_set_expr (XLFnct* self, XString* p_name, XLExpr* p_expr)
{
  self->type = XL_FNCT_TYPE_EXPR;

  x_unref (self->name);
  self->name = x_addref (XString, p_name);

  x_unref (self->expr);
  self->expr = x_addref (XLExpr, p_expr);
}

xvoid
xl_fnct_set_proto (XLFnct* self, XString* p_name)
{
  self->type = XL_FNCT_TYPE_PROTOTYPE;

  x_unref (self->name);
  self->name = x_addref (XString, p_name);
}

xptr
xl_fnct_get_ptr (XLFnct* self)
{
  return NULL;
}

xvoid
xl_fnct_add_param (XLFnct* self, XLField* p_param)
{
  xl_type_resolve (p_param->type);
  x_list_add (self->list_params, (XObject*) p_param);
}

xvoid
xl_fnct_call_init (XLFnct* self)
{
}

xvoid
xl_fnct_push (XLFnct* self, XLData* p_param)
{
}

XLData*
xl_fnct_call (XLFnct* self, XLExpr* p_expr)
{
  XHashTable* l_hash;
  XLVar*      l_var;
  XLData*     l_data;
  XLData*     l_return;
  XLExpr*     l_expr;
  XLField*    l_field;
  XString*    l_name;
  XLType*     l_type;
  xuint       l_size;
  xuint       l_nfparam;
  xuint       l_ncparam;
  xuint       i, j;
  xptr        l_ret;
  xfloat      l_retf;
  xuint       params[100];
  XString*    l_string;

  switch (self->type)
    {
    case XL_FNCT_TYPE_BUILTIN:
      (*(self->builtin)) (p_expr);
      return p_expr->data;
      break;
    case XL_FNCT_TYPE_NATIVE:
      j = 0;
      l_nfparam = x_list_get_size (self->list_params);
      l_ncparam = x_list_get_size (p_expr->list_expr);

      if (!self->opt_param)
	{
	  if (l_nfparam != l_ncparam)
	    {
	      printf ("error: bad number of parameters when calling '%s'\n", x_string_get_str (self->name));
	      exit (0);
	    }
	  l_size = l_nfparam;
	}
      else
	l_size = l_ncparam;

      for (i=0; i<l_size; i++)
	{
	  l_field = (XLField*) x_list_get (self->list_params, i);
	  l_expr =  XL_EXPR (x_list_get (p_expr->list_expr, i));
	  xl_expr_evaluate (l_expr);

	  if (l_expr->data)
	    {
	      if (l_expr->data->type->type == XL_TYPE_TYPE_STRING)
		{
		  if (l_field)
		    {
		      if (l_field->type->type == XL_TYPE_TYPE_STRING)
			params[j] = (xuint) xl_data_get_string (l_expr->data);
		      		    }
		  else
		    params[j] = (xuint) x_access (l_expr->data->raw, 4, xstr);
		}
	      else
		params[j] = (xuint) x_access (l_expr->data->raw, 0, xptr);
	    }
	  else
	    params[j] = 0;

	  j++;
	  
	  x_unref (l_field);
	  x_unref (l_expr);
	}     

      xl_fnct_direct = self->native;
      xl_fnct_direct_void = self->native;
      xl_fnct_direct_float = self->native;
      xl_fnct_direct_void_float = self->native;

      l_ret = 0;

      if (self->ret_type->type == XL_TYPE_TYPE_FLOAT)
	{
	  switch (j)
	    {
	    case 0:
	      l_retf = (*xl_fnct_direct_void_float) ();
	      break;
	    case 1:
	      l_retf = xl_fnct_direct_float (params[0]);
	      break;
	    case 2:
	      l_retf = (*xl_fnct_direct_float) (params[0], params[1]);
	      break;
	    case 3:
	      l_retf = (*xl_fnct_direct_float) (params[0], params[1], params[2]);
	      break;
	    case 4:
	      l_retf = (*xl_fnct_direct_float) (params[0], params[1], params[2], params[3]);
	      break;
	    case 5:
	      l_retf = (*xl_fnct_direct_float) (params[0], params[1], params[2], params[3], params[4]);
	      break;
	    case 6:
	      l_retf = (*xl_fnct_direct_float) (params[0], params[1], params[2], params[3], params[4], 
						params[5]);
	      break;
	    case 7:
	      l_retf = (*xl_fnct_direct_float) (params[0], params[1], params[2], params[3], params[4], 
						params[5], params[6]);
	      break;
	    case 8:
	      l_retf = (*xl_fnct_direct_float) (params[0], params[1], params[2], params[3], params[4], 
						params[5], params[6], params[7]);
	      break;
	    case 9:
	      l_retf = (*xl_fnct_direct_float) (params[0], params[1], params[2], params[3], params[4], 
						params[5], params[6], params[7], params[8]);
	      break;
	    case 10:
	      l_retf = (*xl_fnct_direct_float) (params[0], params[1], params[2], params[3], params[4], 
						params[5], params[6], params[7], params[8], params[9]);
	      break;
	    }
	}
      else
	{
	  switch (j)
	    {
	    case 0:
	      l_ret = (*xl_fnct_direct_void) ();
	      break;
	    case 1:
	      l_ret = (*xl_fnct_direct) (params[0]);
	      break;
	    case 2:
	      l_ret = (*xl_fnct_direct) (params[0], params[1]);
	      break;
	    case 3:
	      l_ret = (*xl_fnct_direct) (params[0], params[1], params[2]);
	      break;
	    case 4:
	      l_ret = (*xl_fnct_direct) (params[0], params[1], params[2], params[3]);
	      break;
	    case 5:
	      l_ret = (*xl_fnct_direct) (params[0], params[1], params[2], params[3], params[4]);
	      break;
	    case 6:
	      l_ret = (*xl_fnct_direct) (params[0], params[1], params[2], params[3], params[4], 
					 params[5]);
	      break;
	    case 7:
	      l_ret = (*xl_fnct_direct) (params[0], params[1], params[2], params[3], params[4], 
					 params[5], params[6]);
	      break;
	    case 8:
	      l_ret = (*xl_fnct_direct) (params[0], params[1], params[2], params[3], params[4], 
					 params[5], params[6], params[7]);
	      break;
	    case 9:
	      l_ret = (*xl_fnct_direct) (params[0], params[1], params[2], params[3], params[4], 
					 params[5], params[6], params[7], params[8]);
	      break;
	    case 10:
	      l_ret = (*xl_fnct_direct) (params[0], params[1], params[2], params[3], params[4], 
					 params[5], params[6], params[7], params[8], params[9]);
	      break;
	    }
	}

      /* Unref string
       */
      j = 0;
      l_size = x_list_get_size (self->list_params);
      for (i=0; i<l_size; i++)
	{
	  l_field = (XLField*) x_list_get (self->list_params, i);
	  l_expr =  XL_EXPR (x_list_get (p_expr->list_expr, i));

	  if (l_expr->data)
	    {
	      if (l_expr->data->type->type == XL_TYPE_TYPE_STRING)
		{
		  if (l_field->type->type == XL_TYPE_TYPE_STRING)
		    {
		      x_unref (X_STRING (params[j]));
		    }
		}
	    }

	  j++;
	  
	  x_unref (l_field);
	  x_unref (l_expr);
	}  

      l_data = xl_data_new (self->ret_type, NULL);

      switch (self->ret_type->type)
	{
	case XL_TYPE_TYPE_STRING:
	  xl_data_set_string (l_data, (XString*) l_ret);
	  x_unref (l_ret);
	  break;
	case XL_TYPE_TYPE_FLOAT:
	  x_access (xl_data_get_raw (l_data), 0, xfloat) = l_retf;
	  break;
	case XL_TYPE_TYPE_DOUBLE:
	  x_access (xl_data_get_raw (l_data), 0, xdouble) = l_retf;
	  break;
	case XL_TYPE_TYPE_BOOL:
	case XL_TYPE_TYPE_CHAR:
	case XL_TYPE_TYPE_UCHAR:
	case XL_TYPE_TYPE_SHORT:
	case XL_TYPE_TYPE_USHORT:
	case XL_TYPE_TYPE_INT:
	case XL_TYPE_TYPE_UINT:
	  x_access (xl_data_get_raw (l_data), 0, xptr) = l_ret;
	  break;
	}

      return l_data;
      break;

    case XL_FNCT_TYPE_EXPR:

      if (p_expr)
	{
	  if (xl_expr_get_size (p_expr) != x_list_get_size (self->list_params))
	    {
	      printf ("error: bad number of parameters in function '%s'\n", x_string_get_str (self->name));
	      exit (-1);
	    }
	}

      if (p_expr)
	{
	  l_size = x_list_get_size (self->list_params);
	  for (i=0; i<l_size; i++)
	    {
	      l_expr =  XL_EXPR (x_list_get (p_expr->list_expr, i));
	      xl_expr_evaluate (l_expr);
	      x_unref (l_expr);
	    }
	}

      l_hash = xl_main_fnct_enter (g_xl_main_global, self); 
    
      if (p_expr)
	{
	  l_size = x_list_get_size (self->list_params);
	  
	  for (i=0; i<l_size; i++)
	    {
	      l_field = (XLField*) x_list_get (self->list_params, i);
	      l_expr =  XL_EXPR (x_list_get (p_expr->list_expr, i));

	      l_name = l_field->name;

	      l_data = xl_data_copy (l_expr->data);
	      l_var = xl_var_new (l_name, l_data);
	      x_unref (l_data);
	  
	      xl_main_add_var (g_xl_main_global, l_var, FALSE);

	      x_unref (l_field);
	      x_unref (l_expr);
	      x_unref (l_var);
	    }
	}     

      g_xl_fnct_halt = FALSE;
      xl_expr_evaluate (self->expr);
      g_xl_fnct_halt = FALSE;
      xl_main_fnct_leave (g_xl_main_global, l_hash);

      l_return = g_xl_fnct_return;
      g_xl_fnct_return = NULL;
      return l_return;
      break;
    default:
      break;	
    }

  return NULL;
}

xvoid
xl_fnct_compile (XLFnct* self)
{
  if (self->type == XL_FNCT_TYPE_EXPR)
    {
      printf ("Compiling function '%s' ...\n", x_string_get_str (self->name));
      xl_compiler_compile (self->expr, self->native_code);
    }
}
