/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xllangpkg.h>
#include <xllang.h>
#include <xlmain.h>

XLLangPkg*
xl_lang_pkg_new ()
{
  XLLangPkg*	self;
  
  self = x_new (XLLangPkg);
  x_object_init_object (X_OBJECT (self), xl_lang_pkg_destroy);

  self->parent.load = xl_lang_pkg_load;
  return self;
}

xvoid
xl_lang_pkg_destroy (XObject* self)
{
  x_destroy (self);
}

XLExpr*
xl_lang_pkg_load (XLLang* self, XString* p_filename)
{
  XLExpr*	l_expr;

  l_expr = xl_expr_new ();
  xl_expr_set_block (l_expr);

  xl_expr_load (l_expr, p_filename);

  return l_expr;
}

