/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <io/xio.h>

xvoid
x_io_write (XString* text)
{
  printf (x_string_get_str (text));
}

xvoid 
x_io_err_write (XString* text)
{
  fprintf (stderr, x_string_get_str (text));
}

xvoid 
x_io_read (XString* text, xuint size)
{
  xstr    l_data;

  l_data = x_alloc (size + 1);
  fgets (l_data, size, stdin);
  x_string_set_str (text, l_data);

  x_destroy (l_data);
}
