/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <wnd/x11/xwnd-x11.h>
#include <xlist.h>

xptr
x_wnd_event_get ()
{
  XEvent     x11event;
  XWndEvent* evt;

  XNextEvent (g_display, &x11event);
  evt = NULL;

  switch  (x11event.type) 
    {
    case Expose:   
      evt = x_wnd_event_new ();
      evt->window = x_wnd_window_lookup ((xptr) x11event.xexpose.window);
      evt->message = XWND_EVENT_WINDOW_PAINT;
      evt->x = 0;
      evt->y = 0;      
      break;
    }

  return evt;
}
