/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __X_ZONE_H_
#define __X_ZONE_H_

#include <xdefs.h>
#include <xobject.h>

#define X_ZONE(obj) ((XZone*) obj)

typedef struct _XZone XZone;
struct _XZone
{
  XObject parent;

  xptr data;
  xuint size;
};

XZone*
x_zone_new ();

xvoid
x_zone_destroy (XZone* self);

xuchar*
x_zone_get_ptr (XZone* self);

xuint
x_zone_get_size (XZone* self);

xvoid
x_zone_set_size (XZone* self, xuint p_size);

xvoid
x_zone_expand (XZone* self, xuint p_extrasize);

xvoid
x_zone_add_byte (XZone* self, xuchar p_data);

xvoid
x_zone_add_dword (XZone* self, xuint p_data);

#endif

