/* X Language Library - The X Language Library
 * Copyright (C) 2002 Patrick Deschenes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */ 


class wndButton 
inherit wndWidget
{
  bool    pushed;
  string  label;

  void wndButton ()
    {
      pushed = false;
      self.wndWidget ();     
    }

  void mouse_click (int x, int y)
    {
      pushed = true;
      self.redraw ();
    }

  void mouse_unclick (int x, int y)
    {
      pushed = false;
      self.redraw ();
    }

  void paint ()
    {
      wndGC  gc;
      uint   w;
      uint   h;
      uint   x;
      uint   y;

      w = self.getWidth ();
      h = self.getHeight ();

      gc = new wndGC;
      gc.acquire (self);

      if (pushed)
	{
	  gc.setFGColor (96, 96, 96);
	  gc.drawLine (0, 0, w, 0);
	  gc.drawLine (0, 0, 0, h);
	  gc.setFGColor (255, 255, 255);
	  gc.drawLine (0, h, w, h);
	  gc.drawLine (w, 0, w, h);
	}
      else
	{
	  gc.setFGColor (255, 255, 255);
	  gc.drawLine (0, 0, w, 0);
	  gc.drawLine (0, 0, 0, h);
	  gc.setFGColor (96, 96, 96);
	  gc.drawLine (0, h, w, h);
	  gc.drawLine (w, 0, w, h);
	}

      gc.drawText ((w - gc.getTextWidth (label)) / 2,
		   (h - gc.getTextHeight (label)) / 2, label);
     
      gc.release (self);
    }

  void create (string text, int x, int y, int w, int h)
    {
      self.label = text;
      self.create_child (x, y, w, h);
    }
}
