/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <wnd/win32/xwnd-win32.h>

xvoid
x_wnd_gc_set_pencil (XWndGC* self, xuint size, xuint type)
{
}

xvoid
x_wnd_gc_set_fg_color (XWndGC* self, xushort red, xushort green, xushort blue)
{
  HPEN hPen;

  hPen = CreatePen (PS_SOLID, 2, RGB (red, green, blue));
  SelectObject ((HDC) self->native_gc, hPen);
}

xvoid
x_wnd_gc_set_bg_color (XWndGC* self, xushort red, xushort green, xushort blue)
{
}

xvoid
x_wnd_gc_set_pos (XWndGC* self, xint x, xint y)
{
}

xint
x_wnd_gc_get_pos_x (XWndGC* self)
{
}

xint
x_wnd_gc_get_pos_y (XWndGC* self)
{
}

xint
x_wnd_gc_get_text_width (XWndGC* self, xstr text)
{
  SIZE size;

  GetTextExtentPoint32 ((HDC) self->native_gc, text, strlen(text), &size);
  return size.cx;
}

xint
x_wnd_gc_get_text_height (XWndGC* self, xstr text)
{
  SIZE size;

  GetTextExtentPoint32 ((HDC) self->native_gc, text, strlen(text), &size);
  return size.cy;
}

xvoid
x_wnd_gc_draw_line (XWndGC* self, xint x1, xint y1, xint x2, xint y2)
{
  MoveToEx ((HDC) self->native_gc, x1, y1, NULL);
  LineTo ((HDC) self->native_gc, x2, y2);
}

xvoid
x_wnd_gc_draw_rectangle (XWndGC* self, xint x, xint y, xuint w, xuint h)
{
  Rectangle ((HDC) self->native_gc, x, y, w, h);
}

xvoid
x_wnd_gc_draw_ellipse (XWndGC* self, xint x, xint y, xuint w, xuint h)
{
}

xvoid
x_wnd_gc_draw_text (XWndGC* self, xint x, xint y, xstr text)
{
  HFONT hFont;

  hFont = CreateFont (6, 6, 0, 0, FW_NORMAL, 0, 0, 0, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS,
		      CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "MS Sans Serif");

  SelectObject ((HDC) self->native_gc, hFont);

  SetBkMode ((HDC) self->native_gc, TRANSPARENT);
  TextOut ((HDC) self->native_gc, x, y, text, strlen (text));
}

xvoid
x_wnd_gc_draw_image (XWndGC* self, xint x, xint y, xuint w, xuint h, XWndImage* img)
{
}
