/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <wnd/xwnd.h>
#include <xlist.h>

XList* g_window_list = NULL;

XWndWindow*
x_wnd_window_new ()
{
  XWndWindow* self;

  self = x_new (XWndWindow);
  x_object_init_object (X_OBJECT (self), x_wnd_window_destroy);

  self->native_window = NULL;

  return self;
}

xvoid
x_wnd_window_destroy (XObject* self)
{
  x_destroy (self);
}

XWndWindow*
x_wnd_window_lookup (xptr native_window)
{
  XWndWindow* window;
  xuint       i;

  for (i=0; i<x_list_get_size (g_window_list); i++)
    {
      window = X_WND_WINDOW (x_list_get (g_window_list, i));
      if (window->native_window == native_window)
	return window;
      
      x_unref (window);
    }

  return NULL;
}


