/* X Language  - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

/* CHANGES:
 *
 * - 06/03/2002 : HashTable support added by Xiong PuXiang (ffxz@gnuchina.org)
 */

#ifndef __X_STRING_H_
#define __X_STRING_H_

#include <xdefs.h>
#include <xobject.h>

#define X_STRING(obj) ((XString*) obj)

typedef struct _XString XString;
struct _XString
{
  XObject parent;

  xstr  data;
  xuint size;
};

XString*
x_string_new ();

xvoid
x_string_destroy (XString* self);

xvoid
x_string_clear (XString* self);

xvoid
x_string_set (XString* self, XString* p_text);

xvoid
x_string_set_str (XString* self, xstr p_text);

xvoid
x_string_add (XString* self, XString* p_text);

xvoid
x_string_add_str (XString* self, xstr p_text);

xvoid
x_string_add_char (XString* self, xchar p_char);

xint
x_string_cmp (XString* self, XString* p_text);

xint
x_string_cmp_str (XString* self, xstr p_text);

xint
x_string_ncmp (XString* self, XString* p_text, xuint p_pos, xuint p_size);

xint
x_string_ncmp_str (XString* self, xstr p_text, xuint p_pos, xuint p_size);

xuint
x_string_get_size (XString* self);

xvoid
x_string_set_size (XString* self, xuint p_size);

xchar
x_string_get_char (XString* self, xuint p_index);

xstr
x_string_get_str (XString* self);

XString*
x_string_extract (XString* self, xuint p_index, xuint p_size);

/* HashTable support (see above)
 */

xbool
x_string_equal(xvoid* self, xvoid* other);

xuint
x_string_hash(xvoid* self);

#endif
