/* X Language Library - The X Language Library
 * Copyright (C) 2002 Patrick Deschenes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */ 

class wndGC
{
  pointer native_gc;
   
  void acquire (wndWidget widget)
    {
      native_gc = wnd_window_get_gc (widget.native_window);
    }

  void release (wndWidget widget)
    {
      wnd_window_release_gc (widget.native_window, native_gc);
    }

  void drawLine (int x1, int y1, int x2, int y2)
    {
      wnd_gc_draw_line (native_gc, x1, y1, x2, y2);
    }

  void drawText (int x, int y, string text)
    {
      wnd_gc_draw_text (native_gc, x, y, text);
    }

  void drawRectangle (int x, int y, int w, int h)
    {
      wnd_gc_draw_rectangle (native_gc, x, y, w, h);
    }
  
  void setFGColor (int r, int g, int b)
    {
      wnd_gc_set_fg_color (native_gc, r, g, b);
    }

  int getTextWidth (string text)
    {
      return wnd_gc_get_text_width (native_gc, text);
    }

  int getTextHeight (string text)
    {
      return wnd_gc_get_text_height (native_gc, text);
    }
}
