/* X Language Library - The X Language Library
 * Copyright (C) 2002 Patrick Deschenes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */ 

class wndWidget
{
  pointer native_window;

  /* Childs
   */

  wndWidget childs[];

  /* Events
   */

  wndEventDispatcher lclickEvent;
  wndEventDispatcher moveEvent;
  wndEventDispatcher closeEvent;
  wndEventDispatcher paintEvent;

  void wndWidget ()
    {
      lclickEvent = new wndEventDispatcher;
      moveEvent = new wndEventDispatcher;
      closeEvent = new wndEventDispatcher;
      paintEvent = new wndEventDispatcher;
    }

  void event_handler (WndEvent evt)
    {
      wndEvent event;

      if (native_window == evt.window)
	{
	  if (evt.message == WND_EVENT_MOUSE_DOWN)
	    {
	      self.mouse_click (evt.x, evt.y);
	      
	      event = new wndEvent;
	      event.x = evt.x;
	      event.y = evt.y;	  
	      lclickEvent.dispatch (self, event);
	    }
	  if (evt.message == WND_EVENT_MOUSE_UP)
	    {
	      self.mouse_unclick (evt.x, evt.y);
	    }
	  if (evt.message == WND_EVENT_WINDOW_CLOSE)
	    {
	      event = new wndEvent;
	      closeEvent.dispatch (self, event);
	    }
	  if (evt.message == WND_EVENT_WINDOW_PAINT)
	    {
	      self.paint ();
	      event = new wndEvent;
	      paintEvent.dispatch (self, event);
	    }
	}
    }

  void create_toplevel (string title, int x, int y, int w, int h)
    {
      native_window = wnd_window_open (title, x, y, w, h, 0);
      wndMain.add (self);
    }

  void create_child (int x, int y, int w, int h)
    {
      native_window = wnd_window_open ("", x, y, w, h, 0);
      wndMain.add (self);
    }

  void redraw ()
    {
      wnd_window_redraw (native_window);
    }

  uint getWidth ()
    {
      return wnd_window_get_size_w (native_window);
    }

  uint getHeight ()
    {
      return wnd_window_get_size_h (native_window);
    }

  void paint ()
    {
    }

  void mouse_click (int x, int y)
    {
    }

  void mouse_unclick (int x, int y)
    {
    }

  void add (wndWidget child)
    {
      childs[].add (child);
    }

  void show ()
    {
      wndWidget child;
      int i;

      wnd_window_set_show (native_window, true);
      
      for (i=0; i<childs[].size; i++)
	{
	  child = childs[i];
	  wnd_window_set_parent (child.native_window, native_window);
	  child.show ();
	}
	/*
      foreach (child in childs)
	{
	  wnd_window_set_parent (child.native_window, native_window);
	  child.show ();
	}
      */
      
    }
}
