/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <xlbuiltin.h>
#include <xlclass.h>
#include <xlmain.h>
#include <xlmeth.h>

#include <xapi/xaapi.h>

xchar xtmp[1000];

xint
xstrfind (xstr str, xstr find, xuint first)
{
  xstr original;
  xstr result;

  original = str;
  original += first;

  result = strstr (original, find);

  if (result)
    return result - str;
  else
    return -1;
}

XString*
xitostr (xuint value)
{
  XString* text;

  text = x_string_new ();
  sprintf (xtmp, "%d", value);
  x_string_set_str (text, xtmp);
  
  return text;
}

xstr
xftostr (xfloat value)
{
  sprintf (xtmp, "%f", value);
  return xtmp;
}

xuint
xstrlen (xstr value)
{
  return strlen (value);
}

xvoid
xa_lang_init ()
{
  /*
  xa_api_reg_fnct ("strtfo", atof, "float",
		   "cstring", "data",
		   NULL);

  xa_api_reg_fnct ("strlen", xstrlen, "uint",
		   "cstring", "data",
		   NULL);

  xa_api_reg_fnct ("strfind", xstrfind, "int",
		   "cstring", "str",
		   "cstring", "find",
		   "uint", "first",
		   NULL);

  xa_api_reg_fnct ("strcmp", strcmp, "int",
		   "cstring", "str_a",
		   "cstring", "str_b",
		   NULL);
  */
  xa_api_reg_fnct ("itostr", xitostr, "string",
		   "uint", "value",
		   NULL);

  /*
  xa_api_reg_fnct ("ftostr", xftostr, "cstring",
		   "float", "value",
		   NULL);	  
  */
}

xvoid
xa_lang_exit ()
{
}
 

