/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <xldefs.h>
#include <builtin/xlbuiltin_assign.h>

xvoid
xl_builtin_assign_init ()
{
  xl_main_add_fnct_builtin (g_xl_main_global, "=", xl_builtin_assign);
}

xvoid
xl_builtin_assign_exit ()
{
}

xvoid
xl_builtin_assign  (XLExpr* p_expr)
{
  XLExpr* l_expr;
  XLData* l_src;
  XLData* l_dst;
  XLData* l_data;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  xl_expr_evaluate (l_expr);
  l_dst = x_addref (XLData, l_expr->data);
  x_unref (l_expr);

  x_unref (p_expr->data);
  l_data = xl_data_new (l_dst->type, NULL);
  xl_data_assign (l_data, l_dst);
  p_expr->data = l_data;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));  
  xl_expr_evaluate (l_expr);
  l_src = x_addref (XLData, l_expr->data);
  x_unref (l_expr);

  xl_data_assign (l_dst, l_src);

  x_unref (l_dst);
  x_unref (l_src);
}
