/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <xldefs.h>
#include <builtin/xlbuiltin_binary.h>

xvoid
xl_builtin_binary_init ()
{
  xl_main_add_fnct_builtin (g_xl_main_global, "&", xl_builtin_binary_and);
  xl_main_add_fnct_builtin (g_xl_main_global, "|", xl_builtin_binary_or);
  xl_main_add_fnct_builtin (g_xl_main_global, "^", xl_builtin_binary_xor);
}

xvoid
xl_builtin_binary_exit ()
{
}

xvoid
xl_builtin_binary_or (XLExpr* p_expr)
{
  xint left, right;

  if (!xl_expr_read_integer (p_expr, 0, &left)) return;
  if (!xl_expr_read_integer (p_expr, 1, &right)) return;

  x_unref (p_expr->data);
  p_expr->data = xl_data_new_integer (left | right);
}

xvoid
xl_builtin_binary_xor (XLExpr* p_expr)
{
  xint left, right;

  if (!xl_expr_read_integer (p_expr, 0, &left)) return;
  if (!xl_expr_read_integer (p_expr, 1, &right)) return;

  x_unref (p_expr->data);
  p_expr->data = xl_data_new_integer (left ^ right);
}

xvoid
xl_builtin_binary_and (XLExpr* p_expr)
{
  xint left, right;

  if (!xl_expr_read_integer (p_expr, 0, &left)) return;
  if (!xl_expr_read_integer (p_expr, 1, &right)) return;

  x_unref (p_expr->data);
  p_expr->data = xl_data_new_integer (left & right);
}

