/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <xldefs.h>
#include <builtin/xlbuiltin_class.h>

xvoid
xl_builtin_class_init ()
{
  xl_main_add_fnct_builtin (g_xl_main_global, "@class", xl_builtin_class); 
  xl_main_add_fnct_builtin (g_xl_main_global, "@meth", xl_builtin_class_meth);
  xl_main_add_fnct_builtin (g_xl_main_global, "@meth_static", xl_builtin_class_meth_static);
  xl_main_add_fnct_builtin (g_xl_main_global, "@prop", xl_builtin_class_prop);
}

xvoid
xl_builtin_class_exit ()
{
}

xvoid
xl_builtin_class (XLExpr* p_expr)
{
  XLExpr*  l_expr;
  XString* l_classname;
  XLClass* l_class;
  xuint    l_size, i;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));

  l_classname = x_string_new ("");
  x_string_add (l_classname, g_xl_builtin_domain);
  x_string_add (l_classname, l_expr->identifier);
  l_class = xl_class_new (l_classname, 0);

  x_unref (l_classname);
  x_unref (l_expr);

  g_xl_builtin_current_class = l_class;
  l_size = x_list_get_size (p_expr->list_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  if (l_expr->expr_type == XL_EXPR_TYPE_IDENTIFIER)
    {
      x_unref (l_class->parent_class_name);
      l_class->parent_class_name = x_addref (XString, l_expr->identifier);
      i = 2;
    }
  else
    i = 1;

  x_unref (l_expr);

  for (; i<l_size; i++)
    {
      l_expr = xl_expr_get (p_expr, i);
      xl_expr_evaluate (l_expr);
      x_unref (l_expr);
    }
  
  xl_main_add_class (g_xl_main_global, l_class);
  x_unref (l_class);

}

xvoid
xl_builtin_class_prop (XLExpr* p_expr)
{
  XLExpr*  l_expr;
  XLType*  l_prop_type;
  XString* l_prop_name;
  XLField* l_field;
  xuint    l_size;


  l_size = xl_expr_get_size (p_expr);

  l_expr = xl_expr_get (p_expr, 0);
  if (xl_expr_check (l_expr, XL_EXPR_TYPE_TYPE))
    {
      l_prop_type = x_addref (XLType, l_expr->type);
      x_unref (l_expr);
    }
  else
    {
      XL_ERROR (XL_ERR_BAD_EXPR, "prop", "prop-type");
      x_unref (l_expr);
      return;
    }

  l_expr = xl_expr_get (p_expr, 1);
  if (xl_expr_check (l_expr, XL_EXPR_TYPE_IDENTIFIER))
    {
      l_prop_name = x_addref (XString, l_expr->identifier);
      x_unref (l_expr);
    }
  else
    {
      XL_ERROR (XL_ERR_BAD_EXPR, "prop", "prop-name");
      x_unref (l_expr);
      return;
    }  

  l_field = xl_field_new (l_prop_name, l_prop_type);
  xl_class_add_field (g_xl_builtin_current_class, l_field);

  x_unref (l_field);
  x_unref (l_prop_type);
  x_unref (l_prop_name);
}

xvoid
xl_builtin_class_meth (XLExpr* p_expr)
{
  XLExpr*  l_expr;
  XLExpr*  l_subexpr;
  XString* l_name;
  XString* l_fnctname;
  XLType*  l_type;
  XLFnct*  l_fnct;
  XLField* l_field;
  XLMeth*  l_meth;
  xuint	   l_size;
  xuint    i;

  l_size = x_list_get_size (p_expr->list_expr);
  
  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_name = x_string_new ();
  x_string_set (l_name, g_xl_builtin_current_class->name);
  x_string_add_str (l_name, "::");
  x_string_add (l_name, l_expr->identifier);
  l_fnctname = x_addref (XString, l_expr->identifier);

  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, l_size - 1));

  l_fnct = xl_main_add_fnct_expr (g_xl_main_global, x_string_get_str (l_name), l_expr);

  /* Adding a XLMeth entry to the class
   */

  l_meth = xl_meth_new (l_fnctname, l_name, XL_METH_NORMAL);
  xl_class_add_method (g_xl_builtin_current_class, l_meth);

  x_unref (l_fnctname);
  x_unref (l_meth);


  x_unref (l_name);
  x_unref (l_expr);

  /* Adding 'self' parameter
   */
  l_name = x_string_new ();
  x_string_set_str (l_name, "self");

  l_type = xl_type_new (XL_TYPE_TYPE_UNKNOWN, XL_TYPE_ARRAY_TYPE_NONE, 0, g_xl_builtin_current_class->name);
  l_field = xl_field_new (l_name, l_type);
  x_unref (l_type);

  xl_fnct_add_param (l_fnct, l_field);
  x_unref (l_name);
  x_unref (l_field);

  for (i=0; i<(l_size / 2) - 1; i++)
    {
      l_subexpr = XL_EXPR (x_list_get (p_expr->list_expr, (i * 2) + 2));
      l_type = x_addref (XLType, l_subexpr->type);
      x_unref (l_type);

      l_subexpr = XL_EXPR (x_list_get (p_expr->list_expr, (i * 2) + 3));

      l_field = xl_field_new (l_subexpr->identifier, l_type);
      xl_fnct_add_param (l_fnct, l_field);

      x_unref (l_type);
      x_unref (l_field);
      x_unref (l_subexpr);
    }
}

xvoid
xl_builtin_class_meth_static (XLExpr* p_expr)
{
  XLExpr*  l_expr;
  XLExpr*  l_subexpr;
  XString* l_name;
  XLFnct*  l_fnct;
  XLType*  l_type;
  XLField* l_field;
  XLMeth*  l_meth;
  xuint	   l_size;
  xuint    i;

  l_size = x_list_get_size (p_expr->list_expr);
  
  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_name = x_string_new ();
  x_string_set (l_name, g_xl_builtin_current_class->name);
  x_string_add_str (l_name, "::");
  x_string_add (l_name, l_expr->identifier);
  x_unref (l_expr);

  l_meth = xl_meth_new (l_expr->identifier, l_name, XL_METH_STATIC);
  xl_class_add_method (g_xl_builtin_current_class, l_meth);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, l_size - 1));
  l_fnct = xl_main_add_fnct_expr (g_xl_main_global, x_string_get_str (l_name), l_expr);
  x_unref (l_name);
  x_unref (l_expr);

  for (i=0; i<(l_size / 2) - 1; i++)
    {
      l_subexpr = XL_EXPR (x_list_get (p_expr->list_expr, (i * 2) + 2));
      l_type = x_addref (XLType, l_subexpr->type);
      x_unref (l_type);

      l_subexpr = XL_EXPR (x_list_get (p_expr->list_expr, (i * 2) + 3));

      l_field = xl_field_new (l_subexpr->identifier, l_type);   
      xl_fnct_add_param (l_fnct, l_field);

      x_unref (l_type);
      x_unref (l_field);
      x_unref (l_subexpr);
    }
}
