/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <xldefs.h>
#include <builtin/xlbuiltin_flow.h>

xvoid
xl_builtin_flow_init ()
{
  xl_main_add_fnct_builtin (g_xl_main_global, "@return", xl_builtin_return);
  xl_main_add_fnct_builtin (g_xl_main_global, "@if", xl_builtin_if);
  xl_main_add_fnct_builtin (g_xl_main_global, "@while", xl_builtin_while);
  xl_main_add_fnct_builtin (g_xl_main_global, "@for", xl_builtin_for);
  xl_main_add_fnct_builtin (g_xl_main_global, "@foreach", xl_builtin_foreach);
}

xvoid
xl_builtin_flow_exit ()
{
}

xvoid
xl_builtin_return (XLExpr* p_expr)
{
  XLExpr* l_expr;
  XLData* l_data;
  
  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));

  if (l_expr)
    {
      xl_expr_evaluate (l_expr);

      l_data = xl_data_new (l_expr->data->type, NULL);
      xl_data_assign (l_data, l_expr->data);

      x_unref (g_xl_fnct_return);
      g_xl_fnct_return = l_data;

      x_unref (l_expr);
    }
  else
    {
      x_unref (g_xl_fnct_return);
      g_xl_fnct_return = NULL;
    }

  g_xl_fnct_halt = TRUE;
}

xvoid
xl_builtin_if (XLExpr* p_expr)
{
  XLExpr* l_test;
  XLExpr* l_true;
  XLExpr* l_false;
  
  l_test = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_true = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_false = XL_EXPR (x_list_get (p_expr->list_expr, 2));

  xl_expr_evaluate (l_test);

  if (x_access (xl_data_get_raw (l_test->data), 0, xbool))
    {
      xl_expr_evaluate (l_true);
    }
  else
    {
      if (l_false)
	xl_expr_evaluate (l_false);
    }

  x_unref (l_test);
  x_unref (l_true);
  x_unref (l_false);
}

xvoid
xl_builtin_while (XLExpr* p_expr)
{
  XLExpr* l_test;
  XLExpr* l_code;
  
  l_test = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_code = XL_EXPR (x_list_get (p_expr->list_expr, 1));

  xl_expr_evaluate (l_test);
  while (x_access (xl_data_get_raw (l_test->data), 0, xbool))
    {
      xl_expr_evaluate (l_code);
      xl_expr_evaluate (l_test);
    }

  x_unref (l_test);
  x_unref (l_code);
}

xvoid
xl_builtin_for (XLExpr* p_expr)
{
  XLExpr* l_start;
  XLExpr* l_test;
  XLExpr* l_end;
  XLExpr* l_code;
  
  l_start = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_test = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_end = XL_EXPR (x_list_get (p_expr->list_expr, 2));
  l_code = XL_EXPR (x_list_get (p_expr->list_expr, 3));

  xl_expr_evaluate (l_start);
  xl_expr_evaluate (l_test);
  while (x_access (xl_data_get_raw (l_test->data), 0, xbool))
    {
      xl_expr_evaluate (l_code);
      xl_expr_evaluate (l_end);
      xl_expr_evaluate (l_test);
    }

  x_unref (l_start);
  x_unref (l_test);
  x_unref (l_end);
  x_unref (l_code);
}

xvoid
xl_builtin_foreach (XLExpr* p_expr)
{
  XLExpr* l_item;
  XLExpr* l_array;
  XLExpr* l_code;
  XLData* l_dataitem;
  xuint   i, size;
  
  l_item = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_array = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_code = XL_EXPR (x_list_get (p_expr->list_expr, 2));

  xl_expr_evaluate (l_item);
  xl_expr_evaluate (l_array);

  size = xl_data_array_get_size (l_array->data);
  for (i=0; i<size; i++)
    {
      l_dataitem = xl_data_get_index (l_array->data, i);
      xl_data_assign (l_item->data, l_dataitem);
      x_unref (l_dataitem);

      xl_expr_evaluate (l_code);
    }

  x_unref (l_code);
  x_unref (l_array);
  x_unref (l_item);
}
