/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <xldefs.h>
#include <xloper.h>
#include <builtin/xlbuiltin_logic.h>

xvoid
xl_builtin_logic_init ()
{
  xl_main_add_fnct_builtin (g_xl_main_global, "<", xl_builtin_cmp_l);
  xl_main_add_fnct_builtin (g_xl_main_global, ">", xl_builtin_cmp_g);
  xl_main_add_fnct_builtin (g_xl_main_global, "<=", xl_builtin_cmp_le);
  xl_main_add_fnct_builtin (g_xl_main_global, ">=", xl_builtin_cmp_ge);
  xl_main_add_fnct_builtin (g_xl_main_global, "!=", xl_builtin_cmp_ne);
  xl_main_add_fnct_builtin (g_xl_main_global, "==", xl_builtin_cmp_e);

  xl_main_add_fnct_builtin (g_xl_main_global, "||", xl_builtin_logic_or);
  xl_main_add_fnct_builtin (g_xl_main_global, "&&", xl_builtin_logic_and);
}

xvoid
xl_builtin_logic_exit ()
{
}

xvoid
xl_builtin_cmp_l (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vbool = oper.operands[0].vint < oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vbool = oper.operands[0].vfloat < oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vbool = oper.operands[0].vdouble < oper.operands[1].vdouble;
      break;
    }

  oper.type = XL_OPER_TYPE_BOOL;
  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_cmp_g (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vbool = oper.operands[0].vint > oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vbool = oper.operands[0].vfloat > oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vbool = oper.operands[0].vdouble > oper.operands[1].vdouble;
      break;
    }

  oper.type = XL_OPER_TYPE_BOOL;
  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_cmp_le (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vbool = oper.operands[0].vint <= oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vbool = oper.operands[0].vfloat <= oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vbool = oper.operands[0].vdouble <= oper.operands[1].vdouble;
      break;
    }

  oper.type = XL_OPER_TYPE_BOOL;
  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_cmp_ge (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vbool = oper.operands[0].vint >= oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vbool = oper.operands[0].vfloat >= oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vbool = oper.operands[0].vdouble >= oper.operands[1].vdouble;
      break;
    }

  oper.type = XL_OPER_TYPE_BOOL;
  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_cmp_ne (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vbool = oper.operands[0].vint != oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vbool = oper.operands[0].vfloat != oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vbool = oper.operands[0].vdouble != oper.operands[1].vdouble;
      break;
    }

  oper.type = XL_OPER_TYPE_BOOL;
  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_cmp_e (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vbool = oper.operands[0].vint == oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vbool = oper.operands[0].vfloat == oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vbool = oper.operands[0].vdouble == oper.operands[1].vdouble;
      break;
    }

  oper.type = XL_OPER_TYPE_BOOL;
  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_logic_or (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_BOOL:
      oper.value.vbool = oper.operands[0].vbool || oper.operands[1].vbool;
      break;
    }

  oper.type = XL_OPER_TYPE_BOOL;
  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_logic_and (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_BOOL:
      oper.value.vbool = oper.operands[0].vbool && oper.operands[1].vbool;
      break;
    }

  oper.type = XL_OPER_TYPE_BOOL;
  xl_oper_return (&oper, &(p_expr->data));
}
