/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <xldefs.h>
#include <xlexpr.h>
#include <builtin/xlbuiltin_math.h>

xvoid
xl_builtin_math_init ()
{
  xl_main_add_fnct_builtin (g_xl_main_global, "+", xl_builtin_add);
  xl_main_add_fnct_builtin (g_xl_main_global, "-", xl_builtin_sub);
  xl_main_add_fnct_builtin (g_xl_main_global, "*", xl_builtin_mul);
  xl_main_add_fnct_builtin (g_xl_main_global, "/", xl_builtin_div);
  xl_main_add_fnct_builtin (g_xl_main_global, "%", xl_builtin_mod);

  xl_main_add_fnct_builtin (g_xl_main_global, "++", xl_builtin_inc);
  xl_main_add_fnct_builtin (g_xl_main_global, "--", xl_builtin_dec);
}


xvoid
xl_builtin_math_exit ()
{
}

xvoid
xl_builtin_add (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vint = oper.operands[0].vint + oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vfloat = oper.operands[0].vfloat + oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vdouble = oper.operands[0].vdouble + oper.operands[1].vdouble;
      break;
    }

  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_sub (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vint = oper.operands[0].vint - oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vfloat = oper.operands[0].vfloat - oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vdouble = oper.operands[0].vdouble - oper.operands[1].vdouble;
      break;
    }

  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_mul (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vint = oper.operands[0].vint * oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vfloat = oper.operands[0].vfloat * oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vdouble = oper.operands[0].vdouble * oper.operands[1].vdouble;
      break;
    }

  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_div (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vint = oper.operands[0].vint / oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vfloat = oper.operands[0].vfloat / oper.operands[1].vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vdouble = oper.operands[0].vdouble / oper.operands[1].vdouble;
      break;
    }

  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_mod (XLExpr* p_expr)
{
  XLOper   oper;

  xl_oper_create (&oper, p_expr);

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vint = oper.operands[0].vint % oper.operands[1].vint;
      break;
    case XL_OPER_TYPE_FLOAT:
    case XL_OPER_TYPE_DOUBLE:
      xl_main_error ("unable to perform a modulo on float");
      break;
    }

  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_inc (XLExpr* p_expr)
{
  XLOper   oper;
  XLExpr*  subexpr;

  xl_oper_create (&oper, p_expr);
  subexpr = XL_EXPR (x_list_get (p_expr->list_expr, 0));

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vint = oper.operands[0].vint;
      oper.value.vint++;
      x_access (xl_data_get_raw (subexpr->data), 0, xint) = oper.value.vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vfloat = oper.operands[0].vfloat;
      oper.value.vfloat++;
      x_access (xl_data_get_raw (subexpr->data), 0, xfloat) = oper.value.vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vdouble = oper.operands[0].vdouble;
      oper.value.vdouble++;
      x_access (xl_data_get_raw (subexpr->data), 0, xdouble) = oper.value.vdouble;
      break;
    }

  x_unref (subexpr);
  xl_oper_return (&oper, &(p_expr->data));
}

xvoid
xl_builtin_dec (XLExpr* p_expr)
{
  XLOper   oper;
  XLExpr*  subexpr;

  xl_oper_create (&oper, p_expr);
  subexpr = XL_EXPR (x_list_get (p_expr->list_expr, 0));

  switch (oper.type)
    {
    case XL_OPER_TYPE_INT:
      oper.value.vint = oper.operands[0].vint;
      oper.value.vint--;
      x_access (xl_data_get_raw (subexpr->data), 0, xint) = oper.value.vint;
      break;
    case XL_OPER_TYPE_FLOAT:
      oper.value.vfloat = oper.operands[0].vfloat;
      oper.value.vfloat--;
      x_access (xl_data_get_raw (subexpr->data), 0, xfloat) = oper.value.vfloat;
      break;
    case XL_OPER_TYPE_DOUBLE:
      oper.value.vdouble = oper.operands[0].vdouble;
      oper.value.vdouble--;
      x_access (xl_data_get_raw (subexpr->data), 0, xdouble) = oper.value.vdouble;
      break;
    }

  x_unref (subexpr);
  xl_oper_return (&oper, &(p_expr->data));
}
