/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <debugger/xldebugger.h>
#include <xlmain.h>
#include <xlfnct.h>

xvoid
xl_debugger_interactive (XLExpr* p_expr, XLFnct* p_fnct)
{
  char cmd[1000];

  printf ("function '%s' in file '%s' at %d\n", 
	  x_string_get_str (p_fnct->name),
	  x_string_get_str (p_expr->source_file), 
	  p_expr->source_line);

  printf ("$ ");
  fflush (stdout);

  scanf ("%s", cmd);
  while (strcmp (cmd, "n") != 0)
    {
      if (strcmp (cmd, "help") == 0)
	{
	  printf ("help       ; Show command helps\n");
	  printf ("n          ; Next step\n");
	  printf ("quit       ; Quit the debugger\n");
	  goto command;
	}
      if (strcmp (cmd, "n") == 0)
	{
	  return;
	}
      if (strcmp (cmd, "quit") == 0)
	{
	  printf ("Quitting the debugger\n");
	  exit (0);
	}

      printf ("Unknown command\n");

    command:
      printf ("$ ");
      fflush (stdout);
      scanf ("%s", cmd);
    }
}

xvoid
xl_debugger_break (XLExpr* p_expr)
{
  XLFnct* l_fnct;
  xuint    l_num;

  if (p_expr->source_file)
    {    
      l_num = x_list_get_size (g_xl_main_global->list_stack);
      l_fnct = XL_FNCT (x_list_get (g_xl_main_global->list_stack, l_num - 1));

      if (l_fnct)
	{
	  xl_debugger_interactive (p_expr, l_fnct);
	}
    }
}







