/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://xlang.sourceforge.net
 */

%{

#include <stdio.h>
#include <stdlib.h>

#include <xltype.h>
#include <xlexpr.h>

#include <xllang.h>
#include <langc_yacc.h>

xchar string_buf[10000];
xchar *string_buf_ptr;

%}

%x comment
%x string
%x character

%%

"//"+[^\n]+\n                 
"/*"                 BEGIN(comment);
<comment>[^*\n]*   
<comment>"*"+[^*/\n]*
<comment>\n          g_lang_line++; 
<comment>"*"+"/"     BEGIN(INITIAL);

\"                   {
                        BEGIN(string);
                        string_buf[0] = '\0';
                        string_buf_ptr = string_buf;
                     }
<string>\\a          *string_buf_ptr++ = '\a';
<string>\\b          *string_buf_ptr++ = '\b';
<string>\\f          *string_buf_ptr++ = '\f';
<string>\\n          *string_buf_ptr++ = '\n';
<string>\\r          *string_buf_ptr++ = '\r';
<string>\\t          *string_buf_ptr++ = '\t';
<string>\\\'         *string_buf_ptr++ = '\'';
<string>\\\"         *string_buf_ptr++ = '\"';
<string>\\\\         *string_buf_ptr++ = '\\';
<string>\\v          *string_buf_ptr++ = '\v';

<string>\\o[0-7]+            {
                                  int  value;
                                  sscanf (&c_text[2], "%o", &value);
                                  *string_buf_ptr++ = (char) value;
                             }
<string>\\u[[:xdigit:]]*     {
                                  int  value;
                                  sscanf (&c_text[2], "%x", &value);
                                  *string_buf_ptr++ = (char) value;
                             }
<string>\\U[[:xdigit:]]+     {
                                  int  value;
                                  sscanf (&c_text[2], "%x", &value);
                                  *string_buf_ptr++ = (char) value;
                             }
<string>\\x[[:xdigit:]]+     {
                                  int  value;
                                  sscanf (&c_text[2], "%x", &value);
                                  *string_buf_ptr++ = (char) value;
                             }
<string>[^\"]                {
                                  *string_buf_ptr++ = c_text[0];
                             }
<string>\"                   {
                                  *string_buf_ptr = '\0';
                                  strcpy (c_lval.vstring, string_buf);
                                  BEGIN(INITIAL);

                                  return VSTRING;
                             }

\'                   BEGIN(character);
<character>\\a       c_lval.vchar = '\a';
<character>\\b       c_lval.vchar = '\b';
<character>\\f       c_lval.vchar = '\f';
<character>\\n       c_lval.vchar = '\n';
<character>\\r       c_lval.vchar = '\r';
<character>\\t       c_lval.vchar = '\t';
<character>\\\'      c_lval.vchar = '\'';
<character>\\\"      c_lval.vchar = '\"';
<character>\\\\      c_lval.vchar = '\\';
<character>\\v       c_lval.vchar = '\v';

<character>\\o[0-7]+         sscanf (&c_text[2], "%o", &c_lval.vchar);
<character>\\u[[:xdigit:]]+  sscanf (&c_text[2], "%x", &c_lval.vchar);
<character>\\U[[:xdigit:]]+  sscanf (&c_text[2], "%x", &c_lval.vchar);
<character>\\x[[:xdigit:]]+  sscanf (&c_text[2], "%x", &c_lval.vchar);
<character>[^\']             c_lval.vchar = c_text[0];
<character>\'                {
                                 BEGIN(INITIAL);
                                 return VCHAR;
                             }

[[:digit:]]+         {
                       c_lval.vint = atoi (c_text);
                       return VINT; 
                     }
0x[[:xdigit:]]+      {
                       sscanf (&c_text[2], "%x", &c_lval.vint);
                       return VINT;
                     }

[[:digit:]]+"."[[:digit:]]*  {
                               c_lval.vfloat = atof (c_text);
                               return VFLOAT;
                             }

"true"               { return VTRUE; }
"false"              { return VFALSE; }
"null"               { return VNULL; }

"void"               { return VOID; }
"char"               { return CHAR; }
"uchar"              { return UCHAR; }
"short"              { return SHORT; }
"ushort"             { return USHORT; }
"int"                { return INT; }
"uint"               { return UINT; }
"float"              { return FLOAT; }
"double"             { return DOUBLE; }
"string"             { return STRING; }
"bool"               { return BOOL; }

"domain"             { return DOMAIN; }
"using"              { return USING; }
"class"              { return CLASS; }
"interface"          { return INTERFACE; }
"inherit"            { return INHERIT; }
"enum"               { return ENUM; }

"const"              { return CONST; }
"static"             { return STATIC; }
"private"            { return PRIVATE; }
"protected"          { return PROTECTED; }
"public"             { return PUBLIC; }

"new"                { return NEW; }

"if"                 { return IF; }
"else"               { return ELSE; }
"return"             { return RETURN; }
"for"                { return FOR; }
"do"                 { return DO; }
"while"              { return WHILE; }
"foreach"            { return FOREACH; }
"in"                 { return IN; }
"switch"             { return SWITCH; }
"case"               { return CASE; }
"default"            { return DEFAULT; }
"break"              { return BREAK; }
"continue"           { return CONTINUE; }

"try"                { return TRY; }
"throw"              { return THROW; }
"catch"              { return CATCH; }

"="                  { return '='; }
">>="                { return ASSIGN_SHR; }
"<<="                { return ASSIGN_SHL; }
"+="                 { return ASSIGN_ADD; }
"-="                 { return ASSIGN_SUB; }
"*="                 { return ASSIGN_MUL; }
"/="                 { return ASSIGN_DIV; }
"%="                 { return ASSIGN_MOD; }
"&="                 { return ASSIGN_AND; }
"^="                 { return ASSIGN_XOR; }
"|="                 { return ASSIGN_OR; } 

"-"                  { return '-'; }
"+"                  { return '+'; }
"*"                  { return '*'; }
"/"                  { return '/'; }
"%"                  { return '%'; }
"++"                 { return OP_INC; }
"--"                 { return OP_DEC; }

"&&"                 { return OP_LOG_AND; }
"||"                 { return OP_LOG_OR; }
"!"                  { return '!'; }
"<"                  { return '<'; }
">"                  { return '>'; }
"<="                 { return OP_LE; }
">="                 { return OP_GE; }
"=="                 { return OP_EQ; }
"!="                 { return OP_NE; }

">>"                 { return OP_SHR; }
"<<"                 { return OP_SHL; }
"~"                  { return '~'; }
"^"                  { return '^'; }
"|"                  { return '!'; }
"&"                  { return '&'; }

"{"                  { return '{'; }
"}"                  { return '}'; }

","                  { return ','; }
"."                  { return '.'; }
";"                  { return ';'; }

"[].size"            { return ARRAY_SIZE; }
"[].resize"          { return ARRAY_RESIZE; }
"[].add"             { return ARRAY_ADD; }


[[:alpha:]_][[:alnum:]_]*    { 
                                strcpy (c_lval.identifier, c_text);
                                if (xl_lang_class_check (c_text))
                                  {
                                    return CLASSNAME;
                                  }
                                else
                                   return IDENTIFIER;
                              }

[ \t\r]              /* White spaces */
[\n]                 { g_lang_line++; }

.		     { return c_text[0]; }






