/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <parser/clike/xllangc.h>
#include <xllang.h>
#include <xlmain.h>
#include <langc_yacc.h>

extern FILE *c_in;

XLLangC*
xl_lang_c_new ()
{
  XLLangC*	self;
  
  self = x_new (XLLangC);
  x_object_init_object (X_OBJECT (self), xl_lang_c_destroy);

  self->parent.load = xl_lang_c_load;
  self->idx = 0;
  self->data = NULL;
  self->fileid = NULL;
  self->line = 1;
  self->oper = FALSE;
  
  return self;
}

xvoid
xl_lang_c_destroy (XObject* self)
{
  x_destroy (self);
}

XLExpr*
xl_lang_c_load (XLLang* self, XString* p_filename)
{
  XLExpr*	l_expr;
  XLExpr*	l_subexpr;

  g_lang_expr = xl_expr_new ();
  xl_expr_set_block (g_lang_expr);

  /* Parsing C-like language
   */

  g_lang_nberr = 0;
  g_lang_line = 1;

  if (!(c_in = fopen (x_string_get_str (p_filename), "rt")))
    {
      printf ("ERROR: Invalid filename\n");
      exit (-1);
    }

  g_lang_filename = x_addref (XString, p_filename);
  c_parse ();
  fclose (c_in);

  x_unref (g_lang_filename);
  x_unref (g_lang_classname);

  if (g_lang_nberr)
    {
      printf ("\n\t%d errors founded\n", g_lang_nberr);
      return NULL;
    }
  else
    return g_lang_expr;
}

xvoid
xl_lang_c_error (char* msg)
{
  g_lang_nberr++;
  fprintf (stderr, "%s:%d: %s\n", x_string_get_str (g_lang_filename), g_lang_line, msg);
}

void
c_error (char *s)
{
}

int
c_wrap ()
{
  return 1;
}
