
/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <config.h>
#include <xldefs.h>
#include <xlbuiltin.h>
#include <builtin/xlbuiltin_class.h>
#include <builtin/xlbuiltin_math.h>
#include <builtin/xlbuiltin_binary.h>
#include <builtin/xlbuiltin_flow.h>
#include <builtin/xlbuiltin_logic.h>
#include <builtin/xlbuiltin_assign.h>

XLClass* g_xl_builtin_current_class = NULL;
XString* g_xl_builtin_domain = NULL;

xvoid
xl_builtin_init ()
{
  /* Declarators
   */

  xl_builtin_class_init ();
  xl_builtin_math_init ();
  xl_builtin_binary_init ();
  xl_builtin_flow_init ();
  xl_builtin_logic_init ();
  xl_builtin_assign_init ();

  xl_main_add_fnct_builtin (g_xl_main_global, "@domain", xl_builtin_domain);
  xl_main_add_fnct_builtin (g_xl_main_global, "@using", xl_builtin_using);

  xl_main_add_fnct_builtin (g_xl_main_global, "@fnct", xl_builtin_fnct);
  xl_main_add_fnct_builtin (g_xl_main_global, "@dlfnct", xl_builtin_dlfnct);
  xl_main_add_fnct_builtin (g_xl_main_global, "@global", xl_builtin_global);
  xl_main_add_fnct_builtin (g_xl_main_global, "@const", xl_builtin_const);
  xl_main_add_fnct_builtin (g_xl_main_global, "@local", xl_builtin_local);

  xl_main_add_fnct_builtin (g_xl_main_global, "@cast", xl_builtin_cast);

  xl_main_add_fnct_builtin (g_xl_main_global, "@import", xl_builtin_import);

  xl_main_add_fnct_builtin (g_xl_main_global, "@new", xl_builtin_new);  
  xl_main_add_fnct_builtin (g_xl_main_global, ".", xl_builtin_access);  
  xl_main_add_fnct_builtin (g_xl_main_global, "::", xl_builtin_invoke);
  xl_main_add_fnct_builtin (g_xl_main_global, "[]", xl_builtin_array);
  xl_main_add_fnct_builtin (g_xl_main_global, "@array_add", xl_builtin_array_add);
  xl_main_add_fnct_builtin (g_xl_main_global, "@array_get_size", xl_builtin_array_get_size);
  xl_main_add_fnct_builtin (g_xl_main_global, "@array_set_size", xl_builtin_array_set_size);
 
  xl_main_add_fnct_builtin (g_xl_main_global, "@", xl_builtin_block);

  g_xl_builtin_domain = x_string_new ("");
}

xvoid
xl_builtin_exit ()
{
  xl_builtin_class_exit ();

  x_unref (g_xl_builtin_domain);
}

xvoid
xl_builtin_domain (XLExpr* p_expr)
{
  XLExpr* l_expr;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));

  x_string_set (g_xl_builtin_domain, l_expr->identifier);
  x_string_add_char (g_xl_builtin_domain, '.');

  x_unref (l_expr);  
}

xvoid
xl_builtin_using (XLExpr* p_expr)
{
}

xvoid
xl_builtin_fnct (XLExpr* p_expr)
{
  XLFnct*  l_fnct;
  XLExpr*  l_expr;
  XString* l_function_name;
  XLType*  l_param_type;
  XString* l_param_name;
  XLField* l_field;
  XLExpr*  l_code;
  xuint    l_size;
  xuint    i;

  l_size = xl_expr_get_size (p_expr);

  l_expr = xl_expr_get (p_expr, 0);
  if (xl_expr_check (l_expr, XL_EXPR_TYPE_TYPE))
    {
      x_unref (l_expr);
    }
  else
    {
      XL_ERROR (XL_ERR_BAD_EXPR, "fnct", "return-type");
      x_unref (l_expr);
      return;
    }

  l_expr = xl_expr_get (p_expr, 1);
  if (xl_expr_check (l_expr, XL_EXPR_TYPE_IDENTIFIER))
    {
      l_function_name = x_addref (XString, l_expr->identifier);
      x_unref (l_expr);
    }
  else
    {
      XL_ERROR (XL_ERR_BAD_EXPR, "fnct", "function-name");
      x_unref (l_expr);
      return;
    }  

  if ((l_size % 2) != 0)
    {
      l_code = xl_expr_get (p_expr, l_size - 1);
      l_fnct = xl_main_add_fnct_expr (g_xl_main_global, x_string_get_str (l_function_name), l_code);
      x_unref (l_function_name);
      x_unref (l_code);
    }
  else
    {
      l_fnct = xl_main_add_fnct_proto (g_xl_main_global, x_string_get_str (l_function_name));
      x_unref (l_function_name);

      return;
    }

  for (i = 0; i < ((l_size - 3) / 2); i++)
    {
      l_expr = xl_expr_get (p_expr, 2 + (i * 2));
      if (xl_expr_check (l_expr, XL_EXPR_TYPE_TYPE))
	{
	  l_param_type = x_addref (XLType, l_expr->type);
	  x_unref (l_expr);
	}
      else
	{
	  XL_ERROR (XL_ERR_BAD_EXPR, "fnct", "param-type");
	  x_unref (l_expr);
	  return;
	}

      l_expr = xl_expr_get (p_expr, 2 + (i * 2) + 1);
      if (xl_expr_check (l_expr, XL_EXPR_TYPE_IDENTIFIER))
	{
	  l_param_name = x_addref (XString, l_expr->identifier);
	  x_unref (l_expr);
	}
      else
	{
	  XL_ERROR (XL_ERR_BAD_EXPR, "fnct", "param-type");
	  x_unref (l_expr);
	  return;
	}

      l_field = xl_field_new (l_param_name, l_param_type);
      xl_fnct_add_param (l_fnct, l_field);

      x_unref (l_param_type);
      x_unref (l_param_name); 
      x_unref (l_field);
    }
}

xvoid
xl_builtin_dlfnct (XLExpr* p_expr)
{
  XLFnct*  l_fnct;
  XLExpr*  l_expr;
  XString* l_function_name;
  XLType*  l_param_type;
  XString* l_param_name;
  XString* l_library_name;
  XString* l_symbol_name;
  xptr     l_library;
  xptr     l_symbol;
  XLField* l_field;
  XLType*  l_type;
  xuint     l_size;
  xuint     i;

  l_size = xl_expr_get_size (p_expr);

  l_expr = xl_expr_get (p_expr, 0);
  xl_expr_evaluate (l_expr);
  l_library_name = xl_data_get_string (l_expr->data);
  x_unref (l_expr);

  l_expr = xl_expr_get (p_expr, 1);
  l_symbol_name = xl_data_get_string (l_expr->data);
  x_unref (l_expr);

  l_expr = xl_expr_get (p_expr, 2);
  if (xl_expr_check (l_expr, XL_EXPR_TYPE_TYPE))
    {
      l_type = x_addref (XLType, l_expr->type);
      x_unref (l_expr);
    }
  else
    {
      XL_ERROR (XL_ERR_BAD_EXPR, "fnct", "return-type");
      x_unref (l_expr);
      return;
    }

  l_expr = xl_expr_get (p_expr, 3);
  if (xl_expr_check (l_expr, XL_EXPR_TYPE_IDENTIFIER))
    {
      l_function_name = x_addref (XString, l_expr->identifier);
      x_unref (l_expr);
    }
  else
    {
      XL_ERROR (XL_ERR_BAD_EXPR, "fnct", "function-name");
      x_unref (l_expr);
      return;
    }  

  l_library = (xptr) x_dynamic_load (x_string_get_str (l_library_name));
  if (!l_library)
    {
      printf ("warning: unable to load library '%s'\n", x_string_get_str (l_library_name));
      return;
    }
  l_symbol = (xptr) x_dynamic_get_symbol (l_library, x_string_get_str (l_symbol_name));

  if (l_symbol)
    {
      l_fnct = xl_main_add_fnct_native (g_xl_main_global, x_string_get_str (l_function_name), l_symbol);
      l_fnct->ret_type = l_type;
    }
  else
    {
      printf ("warning: unkown symbol '%s'\n", x_string_get_str (l_symbol_name));
    }

  x_unref (l_library_name);
  x_unref (l_symbol_name);
  x_unref (l_function_name);

  /* This function has optional parameters
   */

  if ((l_size & 1) == 0)
    {
      l_fnct->opt_param = TRUE;
      l_size--;
    }

  for (i = 0; i < ((l_size - 5) / 2); i++)
    {
      l_expr = xl_expr_get (p_expr, 4 + (i * 2));
      if (xl_expr_check (l_expr, XL_EXPR_TYPE_TYPE))
	{
	  l_param_type = x_addref (XLType, l_expr->type);
	  x_unref (l_expr);
	}
      else
	{
	  XL_ERROR (XL_ERR_BAD_EXPR, "fnct", "param-type");
	  x_unref (l_expr);
	  return;
	}

      l_expr = xl_expr_get (p_expr, 4 + (i * 2) + 1);
      if (xl_expr_check (l_expr, XL_EXPR_TYPE_IDENTIFIER))
	{
	  l_param_name = x_addref (XString, l_expr->identifier);
	  x_unref (l_expr);
	}
      else
	{
	  XL_ERROR (XL_ERR_BAD_EXPR, "fnct", "param-type");
	  x_unref (l_expr);
	  return;
	}

      l_field = xl_field_new (l_param_name, l_param_type);
      xl_fnct_add_param (l_fnct, l_field);

      x_unref (l_param_type);
      x_unref (l_param_name); 
      x_unref (l_field);
    }
}

xvoid
xl_builtin_local (XLExpr* p_expr)
{
  XLExpr*  l_expr;
  XLType*  l_type;
  XString* l_name;
  XLData*  l_data;
  XLVar*   l_var;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_type = l_expr->type;
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_name = l_expr->identifier;
  x_unref (l_expr);

  l_data = xl_data_new (l_type, NULL);
  l_var = xl_var_new (l_name, l_data);

  xl_main_add_var (g_xl_main_global, l_var, FALSE);

  x_unref (l_data);
  x_unref (l_var);
}

xvoid
xl_builtin_global (XLExpr* p_expr)
{
  XLExpr*  l_expr;
  XLType*  l_type;
  XString* l_name;
  XLData*  l_data;
  XLVar*   l_var;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_type = l_expr->type;
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_name = l_expr->identifier;
  x_unref (l_expr);

  l_data = xl_data_new (l_type, NULL);
  l_var = xl_var_new (l_name, l_data);

  xl_main_add_var (g_xl_main_global, l_var, TRUE);

  x_unref (l_data);
  x_unref (l_var);
}

xvoid
xl_builtin_const (XLExpr* p_expr)
{
  XLExpr*  l_expr;
  XLType*  l_type;
  XString* l_name;
  XLData*  l_data;
  XLVar*   l_var;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_type = l_expr->type;
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_name = l_expr->identifier;
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 2));
  xl_expr_evaluate (l_expr);

  l_data = xl_data_new (l_type, NULL);
  xl_data_assign (l_data, l_expr->data);

  x_unref (l_expr);

  l_var = xl_var_new (l_name, l_data);

  xl_main_add_var (g_xl_main_global, l_var, TRUE);

  x_unref (l_data);
  x_unref (l_var);
}


xvoid
xl_builtin_access (XLExpr* p_expr)
{
  XLExpr*  l_expr;
  XLData*  l_data;
  XString* l_field;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  xl_expr_evaluate (l_expr);
  l_data = l_expr->data;
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_field = l_expr->identifier;
  x_unref (l_expr);

  x_unref (p_expr->data);
  p_expr->data = xl_data_get_field (l_data, l_field, TRUE);
}

xvoid
xl_builtin_invoke (XLExpr* p_expr)
{
  XLClass* l_class;
  XLExpr*  l_expr;
  XLExpr*  l_subexpr;
  XLData*  l_data;
  XLMeth*  l_meth;
  XString* l_name;
  xuint    l_size, i;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_expr->check = FALSE;
  xl_expr_evaluate (l_expr);
  l_expr->check = TRUE;

  l_data = x_addref (XLData, l_expr->data);
  if (l_data)
    {
      if (l_data->type->type != XL_TYPE_TYPE_OBJECT)
	{
	  printf ("error: not an object\n");
	  exit (-1);
	}

      l_class = xl_data_get_class (l_data);
      x_unref (l_data);
      if (!l_class)
	{
	  printf ("error-invoke: object is null\n");
	  exit (-1); 
	}
    }
  else
    {      
      l_class = xl_main_get_class (g_xl_main_global, l_expr->identifier);
    }

  x_unref (l_expr);

  if (!l_class)
    return;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  l_meth = xl_class_get_method (l_class, l_expr->identifier);
  x_unref (l_class);
  
  if (!l_meth)
    {
      printf ("error: method '%s' from class '%s' doesn't exists\n",
	      x_string_get_str (l_expr->identifier),
	      x_string_get_str (l_class->name)
	      );
      
      exit (-1);
    }
  x_unref (l_expr);

  l_name = x_addref (XString, l_meth->fnctname);

  l_expr = xl_expr_new ();
  xl_expr_set_fnct (l_expr, l_name);
  x_unref (l_name);

  /* Adding 'self' parameter
   */

  if (l_meth->type == XL_METH_NORMAL)
    {
      l_subexpr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
      xl_expr_add (l_expr, l_subexpr);
      x_unref (l_subexpr);
    }

  x_unref (l_meth);

  l_size = x_list_get_size (p_expr->list_expr);
  for (i=2; i<l_size; i++)
    {
      l_subexpr = XL_EXPR (x_list_get (p_expr->list_expr, i));
      xl_expr_add (l_expr, l_subexpr);
      x_unref (l_subexpr);
    }

  xl_expr_evaluate (l_expr);

  x_unref (p_expr->data);
  p_expr->data = x_addref (XLData, l_expr->data);

  x_unref (l_expr);
}

xvoid
xl_builtin_array (XLExpr* p_expr)
{
  XLExpr* l_expr;
  XLData* l_data;
  XLData* l_index;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  xl_expr_evaluate (l_expr);
  l_data = x_addref (XLData, l_expr->data);
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  xl_expr_evaluate (l_expr);
  l_index = x_addref (XLData, l_expr->data);
  x_unref (l_expr);

  x_unref (p_expr->data);
  p_expr->data = xl_data_get_index (l_data, x_access (xl_data_get_raw (l_index), 0, xuint));

  x_unref (l_data);
  x_unref (l_index);
}

xvoid
xl_builtin_array_add (XLExpr* p_expr)
{
  XLExpr* l_expr;
  XLData* l_data;
  XLData* l_dst;
  XLData* l_src;
  xuint   l_size;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  xl_expr_evaluate (l_expr);
  l_data = l_expr->data;
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  xl_expr_evaluate (l_expr);
  l_src = l_expr->data;
  x_unref (l_expr);

  l_size = xl_data_array_get_size (l_data);
  xl_data_array_set_size (l_data, l_size + 1);

  l_dst = xl_data_get_index (l_data, l_size);
  xl_data_assign (l_dst, l_src);

  x_unref (l_dst);
}

xvoid
xl_builtin_array_get_size (XLExpr* p_expr)
{
  XLExpr* l_expr;
  XLData* l_data;
  XLType* l_rettype;
  XLData* l_retdata;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  xl_expr_evaluate (l_expr);
  l_data = x_addref (XLData, l_expr->data);
  x_unref (l_expr);

  l_rettype = xl_type_new (XL_TYPE_TYPE_UINT, XL_TYPE_ARRAY_TYPE_NONE, 0, NULL);
  l_retdata = xl_data_new (l_rettype, NULL);
  x_unref (l_rettype);

  x_access (xl_data_get_raw (l_retdata), 0, xuint) = xl_data_array_get_size (l_data);
  x_unref (l_data);

  x_unref (p_expr->data);
  p_expr->data = l_retdata;
}

xvoid
xl_builtin_array_set_size (XLExpr* p_expr)
{
  XLExpr* l_expr;
  XLData* l_data;
  xuint   l_newsize;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  xl_expr_evaluate (l_expr);
  l_data = x_addref (XLData, l_expr->data);
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  xl_expr_evaluate (l_expr);
  l_newsize = x_access (xl_data_get_raw (l_expr->data), 0, xuint);
  x_unref (l_expr);

  xl_data_array_set_size (l_data, l_newsize);

  x_unref (l_data);
}

xvoid
xl_builtin_new (XLExpr* p_expr)
{
  XLClass*        l_class;
  XLExpr*         l_expr;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));
  xl_expr_evaluate (l_expr);
  l_class = xl_type_get_class (l_expr->type);
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));  
  xl_expr_evaluate (l_expr);

  if (l_class)
    xl_data_object_new (l_expr->data, l_class);
  else
    printf ("ERROR: unknown class\n");

  x_unref (l_expr);
}

xvoid
xl_builtin_cast  (XLExpr* p_expr)
{
  XLExpr* l_expr;
  XLData* l_src;
  XLData* l_dst;

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  l_dst = xl_data_new (l_expr->type, NULL);
  x_unref (l_expr);

  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 1));  
  xl_expr_evaluate (l_expr);
  l_src = x_addref (XLData, l_expr->data);
  x_unref (l_expr);

  xl_data_assign (l_dst, l_src);
  x_unref (p_expr->data);
  p_expr->data = x_addref (XLData, l_dst);

  x_unref (l_dst);
  x_unref (l_src);
}

xvoid
xl_builtin_io_write (XLExpr* p_expr)
{
  XLExpr* l_expr;
  XLData* l_data;
  XString*l_text;
  
  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  xl_expr_evaluate (l_expr);

  l_data = l_expr->data;
  x_unref (l_expr);

  if (!l_data)
    {
      printf ("ERROR: data = NULL\n");
      return;
    }
  
  if (l_data->type->type == XL_TYPE_TYPE_STRING)
    {
      l_text = xl_data_get_string (l_data);
      printf ("%s", x_string_get_str (l_text));
      x_unref (l_text);
    }

  if (l_data->type->type == XL_TYPE_TYPE_UINT)
    {
      printf ("%d", x_access (xl_data_get_raw (l_data), 0, xuint));
    }
}

xvoid
xl_builtin_block (XLExpr* p_expr)
{
  XLExpr*	 l_expr;
  xuint		 l_size;
  xuint		 i;
  
  l_size = x_list_get_size (p_expr->list_expr);
  
  for (i = 0; i < l_size; i++)
    {
      l_expr = XL_EXPR (x_list_get (p_expr->list_expr, i));
      xl_expr_evaluate (l_expr);
      x_unref (l_expr);

      if (g_xl_fnct_halt)
	return;
    }
}


xvoid
xl_builtin_import (XLExpr* p_expr)
{
  XLLang*      l_lang;
  XLExpr*      l_expr;
  XLData*      l_data;
  XString*     l_text;
  
  l_expr = XL_EXPR (x_list_get (p_expr->list_expr, 0));
  xl_expr_evaluate (l_expr);
  
  l_data = l_expr->data;
  x_unref (l_expr);
  
  if (l_data->type->type == XL_TYPE_TYPE_STRING)
    {
      l_text = xl_data_get_string (l_data);
      l_lang = xl_lang_new (x_string_get_str (l_text));
      l_expr = (*(l_lang->load)) (l_lang, l_text);

      if (l_expr)
	{
	  xl_expr_evaluate (l_expr);
	  x_unref (l_expr);
	}

      x_unref (l_lang);
      x_unref (l_text);
    }
}


